/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.Closeable;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static Logger logger_ = LoggerFactory.getLogger(FileUtils.class);
    private static final DecimalFormat df_ = new DecimalFormat("#.##");
    private static final double kb_ = 1024.0;
    private static final double mb_ = 1048576.0;
    private static final double gb_ = 1.073741824E9;
    private static final double tb_ = 1.099511627776E12;

    public static void deleteWithConfirm(String file) throws IOException {
        FileUtils.deleteWithConfirm(new File(file));
    }

    public static void deleteWithConfirm(File file) throws IOException {
        assert (file.exists()) : "attempted to delete non-existing file " + file.getName();
        if (logger_.isDebugEnabled()) {
            logger_.debug("Deleting " + file.getName());
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete " + file.getAbsolutePath());
        }
    }

    public static void renameWithConfirm(File from, File to) throws IOException {
        assert (from.exists());
        if (logger_.isDebugEnabled()) {
            logger_.debug(String.format("Renaming %s to %s", from.getPath(), to.getPath()));
        }
        if (!from.renameTo(to)) {
            throw new IOException(String.format("Failed to rename %s to %s", from.getPath(), to.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncate(String path, long size) throws IOException {
        RandomAccessFile file;
        try {
            file = new RandomAccessFile(path, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            file.getChannel().truncate(size);
        }
        finally {
            file.close();
        }
    }

    public static void closeQuietly(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            logger_.warn("Failed closing stream", (Throwable)e);
        }
    }

    public static void close(Iterable<? extends Closeable> cs) throws IOException {
        IOException e = null;
        for (Closeable closeable : cs) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException ex) {
                e = ex;
                logger_.warn("Failed closing stream " + closeable, (Throwable)ex);
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public static void createDirectory(String directory) throws IOException {
        File file = new File(directory);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("unable to mkdirs " + directory);
        }
    }

    public static boolean delete(String file) {
        File f = new File(file);
        return f.delete();
    }

    public static boolean delete(List<String> files) {
        boolean bVal = true;
        for (int i = 0; i < files.size(); ++i) {
            String file = files.get(i);
            bVal = FileUtils.delete(file);
            if (!bVal) continue;
            if (logger_.isDebugEnabled()) {
                logger_.debug("Deleted file {}", (Object)file);
            }
            files.remove(i);
        }
        return bVal;
    }

    public static void delete(File[] files) {
        for (File file : files) {
            file.delete();
        }
    }

    public static String stringifyFileSize(double value) {
        if (value >= 1.099511627776E12) {
            double d = value / 1.099511627776E12;
            String val = df_.format(d);
            return val + " TB";
        }
        if (value >= 1.073741824E9) {
            double d = value / 1.073741824E9;
            String val = df_.format(d);
            return val + " GB";
        }
        if (value >= 1048576.0) {
            double d = value / 1048576.0;
            String val = df_.format(d);
            return val + " MB";
        }
        if (value >= 1024.0) {
            double d = value / 1024.0;
            String val = df_.format(d);
            return val + " KB";
        }
        String val = df_.format(value);
        return val + " bytes";
    }

    public static void deleteRecursive(File dir) throws IOException {
        if (dir.isDirectory()) {
            String[] children;
            for (String child : children = dir.list()) {
                FileUtils.deleteRecursive(new File(dir, child));
            }
        }
        FileUtils.deleteWithConfirm(dir);
    }

    public static void skipBytesFully(DataInput in, int bytes) throws IOException {
        int skipped;
        for (int n = 0; n < bytes; n += skipped) {
            skipped = in.skipBytes(bytes - n);
            if (skipped != 0) continue;
            throw new EOFException("EOF after " + n + " bytes out of " + bytes);
        }
    }

    public static void skipBytesFully(DataInput in, long bytes) throws IOException {
        int skipped;
        for (long n = 0L; n < bytes; n += (long)skipped) {
            int m = (int)Math.min(Integer.MAX_VALUE, bytes - n);
            skipped = in.skipBytes(m);
            if (skipped != 0) continue;
            throw new EOFException("EOF after " + n + " bytes out of " + bytes);
        }
    }

    public static class FileComparator
    implements Comparator<File> {
        @Override
        public int compare(File f, File f2) {
            return (int)(f.lastModified() - f2.lastModified());
        }
    }
}

