/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.IColumn;

class ColumnIterator
implements Iterator<Map.Entry<ByteBuffer, IColumn>> {
    private final ColumnSerializer serializer;
    private final DataInput dis;
    private final int length;
    private final boolean fromRemote;
    private int count = 0;
    private ColumnFamilyStore interner;
    private final int expireBefore;

    public ColumnIterator(ColumnSerializer serializer, DataInput dis, ColumnFamilyStore interner, int length, boolean fromRemote, int expireBefore) {
        this.dis = dis;
        this.serializer = serializer;
        this.interner = interner;
        this.length = length;
        this.fromRemote = fromRemote;
        this.expireBefore = expireBefore;
    }

    private IColumn deserializeNext() {
        try {
            ++this.count;
            return this.serializer.deserialize(this.dis, this.interner, this.fromRemote, this.expireBefore);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.count < this.length;
    }

    @Override
    public Map.Entry<ByteBuffer, IColumn> next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("end of column iterator");
        }
        final IColumn column = this.deserializeNext();
        return new Map.Entry<ByteBuffer, IColumn>(){

            @Override
            public IColumn setValue(IColumn value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public IColumn getValue() {
                return column;
            }

            @Override
            public ByteBuffer getKey() {
                return column.name();
            }
        };
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

