/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

public class DropKeyspace
extends Migration {
    private String name;

    protected DropKeyspace() {
    }

    public DropKeyspace(String name) throws ConfigurationException, IOException {
        super(UUIDGen.makeType1UUIDFromHost(FBUtilities.getLocalAddress()), DatabaseDescriptor.getDefsVersion());
        this.name = name;
        KSMetaData ksm = DatabaseDescriptor.getTableDefinition(name);
        if (ksm == null) {
            throw new ConfigurationException("Keyspace does not exist.");
        }
        this.rm = DropKeyspace.makeDefinitionMutation(null, ksm, this.newVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyModels() throws IOException {
        String snapshotName = Table.getTimestampedSnapshotName(null);
        CompactionManager.instance.getCompactionLock().lock();
        try {
            KSMetaData ksm = DatabaseDescriptor.getTableDefinition(this.name);
            for (CFMetaData cfm : ksm.cfMetaData().values()) {
                ColumnFamilyStore cfs = Table.open(ksm.name).getColumnFamilyStore(cfm.cfName);
                CFMetaData.purge(cfm);
                if (StorageService.instance.isClientMode()) continue;
                cfs.snapshot(snapshotName);
                cfs.flushLock.lock();
                try {
                    Table.open(ksm.name).dropCf(cfm.cfId);
                }
                finally {
                    cfs.flushLock.unlock();
                }
            }
            Table.clear(ksm.name);
            DatabaseDescriptor.clearTableDefinition(ksm, this.newVersion);
        }
        finally {
            CompactionManager.instance.getCompactionLock().unlock();
        }
    }

    @Override
    public void subdeflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.DropKeyspace dks = new org.apache.cassandra.db.migration.avro.DropKeyspace();
        dks.ksname = new Utf8(this.name);
        mi.migration = dks;
    }

    @Override
    public void subinflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.DropKeyspace dks = (org.apache.cassandra.db.migration.avro.DropKeyspace)((Object)mi.migration);
        this.name = ((Object)dks.ksname).toString();
    }

    public String toString() {
        return "Drop keyspace: " + this.name;
    }
}

