/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.utils.ByteBufferUtil;

public class MemtableAllocator {
    private static final int REGION_SIZE = 0x200000;
    private static final int MAX_CLONED_SIZE = 262144;
    private final AtomicReference<Region> currentRegion = new AtomicReference();
    private final Collection<Region> filledRegions = new LinkedBlockingQueue<Region>();

    public ByteBuffer clone(ByteBuffer buffer) {
        assert (buffer != null);
        if (buffer.remaining() > 262144) {
            return ByteBufferUtil.clone(buffer);
        }
        while (true) {
            Region region;
            ByteBuffer cloned;
            if ((cloned = (region = this.getRegion()).allocate(buffer.remaining())) != null) {
                cloned.mark();
                cloned.put(buffer.duplicate());
                cloned.reset();
                return cloned;
            }
            this.tryRetireRegion(region);
        }
    }

    private void tryRetireRegion(Region region) {
        if (this.currentRegion.compareAndSet(region, null)) {
            this.filledRegions.add(region);
        }
    }

    private Region getRegion() {
        Region region;
        do {
            if ((region = this.currentRegion.get()) == null) continue;
            return region;
        } while (!this.currentRegion.compareAndSet(null, region = new Region(0x200000)));
        region.init();
        return region;
    }

    private static class Region {
        private ByteBuffer data;
        private static final int UNINITIALIZED = -1;
        private AtomicInteger nextFreeOffset = new AtomicInteger(-1);
        private AtomicInteger allocCount = new AtomicInteger();
        private final int size;

        private Region(int size) {
            this.size = size;
        }

        public void init() {
            assert (this.nextFreeOffset.get() == -1);
            this.data = ByteBuffer.allocate(this.size);
            assert (this.data.remaining() == this.data.capacity());
            boolean initted = this.nextFreeOffset.compareAndSet(-1, 0);
            Preconditions.checkState((boolean)initted, (Object)"Multiple threads tried to init same region");
        }

        public ByteBuffer allocate(int size) {
            int oldOffset;
            while (true) {
                if ((oldOffset = this.nextFreeOffset.get()) == -1) {
                    Thread.yield();
                    continue;
                }
                if (oldOffset + size > this.data.capacity()) {
                    return null;
                }
                if (this.nextFreeOffset.compareAndSet(oldOffset, oldOffset + size)) break;
            }
            this.allocCount.incrementAndGet();
            return (ByteBuffer)this.data.duplicate().position(oldOffset);
        }

        public String toString() {
            return "Region@" + System.identityHashCode(this) + " allocs=" + this.allocCount.get() + "waste=" + (this.data.capacity() - this.nextFreeOffset.get());
        }
    }
}

