/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import org.apache.cassandra.cql.EntityType;
import org.apache.cassandra.cql.RelationType;
import org.apache.cassandra.cql.Term;

public class Relation {
    private EntityType entityType = EntityType.COLUMN;
    private Term entity;
    private RelationType relationType;
    private Term value;

    public Relation(Term entity, String type, Term value) {
        if (entity.getText().toUpperCase().equals("KEY")) {
            this.entityType = EntityType.KEY;
        }
        this.entity = entity;
        this.relationType = RelationType.forString(type);
        this.value = value;
    }

    public boolean isKey() {
        return this.entityType.equals((Object)EntityType.KEY);
    }

    public boolean isColumn() {
        return this.entityType.equals((Object)EntityType.COLUMN);
    }

    public RelationType operator() {
        return this.relationType;
    }

    public Term getEntity() {
        return this.entity;
    }

    public Term getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("Relation(%s, %s,nnn %s)", new Object[]{this.entity, this.relationType, this.value});
    }
}

