/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.AsyncRepairCallback;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IReadCommand;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.RowDigestResolver;
import org.apache.cassandra.service.RowRepairResolver;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.SimpleCondition;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCallback<T>
implements IAsyncCallback {
    protected static final Logger logger = LoggerFactory.getLogger(ReadCallback.class);
    private static final ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    public final IResponseResolver<T> resolver;
    protected final SimpleCondition condition = new SimpleCondition();
    private final long startTime;
    protected final int blockfor;
    final List<InetAddress> endpoints;
    private final IReadCommand command;
    protected final AtomicInteger received = new AtomicInteger(0);

    public ReadCallback(IResponseResolver<T> resolver, ConsistencyLevel consistencyLevel, IReadCommand command, List<InetAddress> endpoints) {
        this.command = command;
        this.blockfor = this.determineBlockFor(consistencyLevel, command.getKeyspace());
        this.resolver = resolver;
        this.startTime = System.currentTimeMillis();
        boolean repair = this.randomlyReadRepair();
        List<InetAddress> list = this.endpoints = repair || resolver instanceof RowRepairResolver ? endpoints : endpoints.subList(0, Math.min(endpoints.size(), this.blockfor));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Blockfor/repair is %s/%s; setting up requests to %s", this.blockfor, repair, StringUtils.join(this.endpoints, (String)",")));
        }
    }

    private boolean randomlyReadRepair() {
        if (this.resolver instanceof RowDigestResolver) {
            assert (this.command instanceof ReadCommand) : this.command;
            String table = ((RowDigestResolver)this.resolver).table;
            String columnFamily = ((ReadCommand)this.command).getColumnFamilyName();
            CFMetaData cfmd = DatabaseDescriptor.getTableMetaData(table).get(columnFamily);
            return cfmd.getReadRepairChance() > random.get().nextDouble();
        }
        return false;
    }

    public T get() throws TimeoutException, DigestMismatchException, IOException {
        boolean success;
        long timeout = DatabaseDescriptor.getRpcTimeout() - (System.currentTimeMillis() - this.startTime);
        try {
            success = this.condition.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!success) {
            StringBuilder sb = new StringBuilder("");
            for (Message message : this.resolver.getMessages()) {
                sb.append(message.getFrom()).append(", ");
            }
            throw new TimeoutException("Operation timed out - received only " + this.received.get() + " responses from " + sb.toString() + " .");
        }
        return this.blockfor == 1 ? this.resolver.getData() : this.resolver.resolve();
    }

    @Override
    public void response(Message message) {
        int n;
        this.resolver.preprocess(message);
        int n2 = n = this.waitingFor(message) ? this.received.incrementAndGet() : this.received.get();
        if (n >= this.blockfor && this.resolver.isDataPresent()) {
            this.condition.signal();
            this.maybeResolveForRepair();
        }
    }

    protected boolean waitingFor(Message message) {
        return true;
    }

    protected boolean waitingFor(ReadResponse response) {
        return true;
    }

    public void response(ReadResponse result) {
        int n;
        ((RowDigestResolver)this.resolver).injectPreProcessed(result);
        int n2 = n = this.waitingFor(result) ? this.received.incrementAndGet() : this.received.get();
        if (n >= this.blockfor && this.resolver.isDataPresent()) {
            this.condition.signal();
            this.maybeResolveForRepair();
        }
    }

    protected void maybeResolveForRepair() {
        if (this.blockfor < this.endpoints.size() && this.received.get() == this.endpoints.size()) {
            assert (this.resolver.isDataPresent());
            StageManager.getStage(Stage.READ_REPAIR).execute(new AsyncRepairRunner());
        }
    }

    public int determineBlockFor(ConsistencyLevel consistencyLevel, String table) {
        switch (consistencyLevel) {
            case ONE: 
            case ANY: {
                return 1;
            }
            case TWO: {
                return 2;
            }
            case THREE: {
                return 3;
            }
            case QUORUM: {
                return Table.open(table).getReplicationStrategy().getReplicationFactor() / 2 + 1;
            }
            case ALL: {
                return Table.open(table).getReplicationStrategy().getReplicationFactor();
            }
        }
        throw new UnsupportedOperationException("invalid consistency level: " + consistencyLevel);
    }

    public void assureSufficientLiveNodes() throws UnavailableException {
        if (this.endpoints.size() < this.blockfor) {
            throw new UnavailableException();
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return true;
    }

    private class AsyncRepairRunner
    extends WrappedRunnable {
        private AsyncRepairRunner() {
        }

        @Override
        protected void runMayThrow() throws IOException {
            try {
                ReadCallback.this.resolver.resolve();
            }
            catch (DigestMismatchException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Digest mismatch:", (Throwable)e);
                }
                ReadCommand readCommand = (ReadCommand)ReadCallback.this.command;
                RowRepairResolver repairResolver = new RowRepairResolver(readCommand.table, readCommand.key);
                AsyncRepairCallback repairHandler = new AsyncRepairCallback(repairResolver, ReadCallback.this.endpoints.size());
                for (InetAddress endpoint : ReadCallback.this.endpoints) {
                    MessagingService.instance().sendRR(readCommand, endpoint, repairHandler);
                }
            }
        }
    }
}

