/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.Serializable;
import org.apache.cassandra.io.CompactionType;

public final class CompactionInfo
implements Serializable {
    private final String ksname;
    private final String cfname;
    private final CompactionType tasktype;
    private final long bytesComplete;
    private final long totalBytes;

    public CompactionInfo(String ksname, String cfname, CompactionType tasktype, long bytesComplete, long totalBytes) {
        this.ksname = ksname;
        this.cfname = cfname;
        this.tasktype = tasktype;
        this.bytesComplete = bytesComplete;
        this.totalBytes = totalBytes;
    }

    public CompactionInfo forProgress(long bytesComplete, long totalBytes) {
        return new CompactionInfo(this.ksname, this.cfname, this.tasktype, bytesComplete, totalBytes);
    }

    public String getKeyspace() {
        return this.ksname;
    }

    public String getColumnFamily() {
        return this.cfname;
    }

    public long getBytesComplete() {
        return this.bytesComplete;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public CompactionType getTaskType() {
        return this.tasktype;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append((Object)this.getTaskType()).append('@').append(this.hashCode());
        buff.append('(').append(this.getKeyspace()).append(", ").append(this.getColumnFamily());
        buff.append(", ").append(this.getBytesComplete()).append('/').append(this.getTotalBytes());
        return buff.append(')').toString();
    }

    public static interface Holder {
        public CompactionInfo getCompactionInfo();
    }
}

