/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.sstable.SSTableReader;

public class CompactionController {
    private final ColumnFamilyStore cfs;
    private final Set<SSTableReader> sstables;
    private final boolean forceDeserialize;
    public final boolean isMajor;
    public final int gcBefore;
    private static final CompactionController basicController = new CompactionController(null, Collections.<SSTableReader>emptySet(), false, Integer.MAX_VALUE, false);
    private static final CompactionController basicDeserializingController = new CompactionController(null, Collections.<SSTableReader>emptySet(), false, Integer.MAX_VALUE, true);

    public CompactionController(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, boolean isMajor, int gcBefore, boolean forceDeserialize) {
        this.cfs = cfs;
        this.isMajor = isMajor;
        this.sstables = new HashSet<SSTableReader>(sstables);
        this.gcBefore = gcBefore;
        this.forceDeserialize = forceDeserialize;
    }

    public static CompactionController getBasicController(boolean forceDeserialize) {
        return forceDeserialize ? basicDeserializingController : basicController;
    }

    public String getKeyspace() {
        return this.cfs != null ? this.cfs.table.name : "n/a";
    }

    public String getColumnFamily() {
        return this.cfs != null ? this.cfs.columnFamily : "n/a";
    }

    public boolean shouldPurge(DecoratedKey key) {
        return this.isMajor || this.cfs != null && !this.cfs.isKeyInRemainingSSTables(key, this.sstables);
    }

    public boolean needDeserialize() {
        if (this.forceDeserialize) {
            return true;
        }
        for (SSTableReader sstable : this.sstables) {
            if (sstable.descriptor.isLatestVersion) continue;
            return true;
        }
        return false;
    }

    public void invalidateCachedRow(DecoratedKey key) {
        if (this.cfs != null) {
            this.cfs.invalidateCachedRow(key);
        }
    }

    public void removeDeletedInCache(DecoratedKey key) {
        ColumnFamily cachedRow;
        if (this.cfs != null && (cachedRow = this.cfs.getRawCachedRow(key)) != null) {
            ColumnFamilyStore.removeDeleted(cachedRow, this.gcBefore);
        }
    }
}

