/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.InstrumentingCache;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CompactionManager;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.CompactionInfo;
import org.apache.cassandra.io.CompactionType;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AutoSavingCache<K, V>
extends InstrumentingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AutoSavingCache.class);
    public static final AtomicBoolean flushInProgress = new AtomicBoolean(false);
    protected final String cfName;
    protected final String tableName;
    protected volatile ScheduledFuture<?> saveTask;
    protected final ColumnFamilyStore.CacheType cacheType;

    public AutoSavingCache(ICache<K, V> cache, String tableName, String cfName, ColumnFamilyStore.CacheType cacheType) {
        super(cache, tableName, cfName + (Object)((Object)cacheType));
        this.tableName = tableName;
        this.cfName = cfName;
        this.cacheType = cacheType;
    }

    public abstract ByteBuffer translateKey(K var1);

    public abstract double getConfiguredCacheSize(CFMetaData var1);

    public int getAdjustedCacheSize(long expectedKeys) {
        CFMetaData cfm = DatabaseDescriptor.getCFMetaData(this.tableName, this.cfName);
        return (int)Math.min(FBUtilities.absoluteFromFraction(this.getConfiguredCacheSize(cfm), expectedKeys), Integer.MAX_VALUE);
    }

    public File getCachePath() {
        return DatabaseDescriptor.getSerializedCachePath(this.tableName, this.cfName, this.cacheType);
    }

    public Writer getWriter() {
        return new Writer(this.tableName, this.cfName);
    }

    public void scheduleSaving(int savePeriodInSeconds) {
        if (this.saveTask != null) {
            this.saveTask.cancel(false);
            this.saveTask = null;
        }
        if (savePeriodInSeconds > 0) {
            WrappedRunnable runnable = new WrappedRunnable(){

                @Override
                public void runMayThrow() {
                    AutoSavingCache.this.submitWrite();
                }
            };
            this.saveTask = StorageService.tasks.scheduleWithFixedDelay(runnable, savePeriodInSeconds, savePeriodInSeconds, TimeUnit.SECONDS);
        }
    }

    public Future<?> submitWrite() {
        return CompactionManager.instance.submitCacheWrite(this.getWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DecoratedKey> readSaved() {
        File path = this.getCachePath();
        TreeSet<DecoratedKey> keys = new TreeSet<DecoratedKey>();
        if (path.exists()) {
            DataInputStream in = null;
            try {
                long start = System.currentTimeMillis();
                logger.info(String.format("reading saved cache %s", path));
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(path)));
                while (in.available() > 0) {
                    DecoratedKey key;
                    int size = in.readInt();
                    byte[] bytes = new byte[size];
                    in.readFully(bytes);
                    ByteBuffer buffer = ByteBuffer.wrap(bytes);
                    try {
                        key = StorageService.getPartitioner().decorateKey(buffer);
                    }
                    catch (Exception e) {
                        logger.info(String.format("unable to read entry #%s from saved cache %s; skipping remaining entries", keys.size(), path.getAbsolutePath()), (Throwable)e);
                        break;
                    }
                    keys.add(key);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("completed reading (%d ms; %d keys) saved cache %s", System.currentTimeMillis() - start, keys.size(), path));
                }
                FileUtils.closeQuietly(in);
            }
            catch (IOException ioe) {
                logger.warn(String.format("error reading saved cache %s", path.getAbsolutePath()), (Throwable)ioe);
            }
            finally {
                FileUtils.closeQuietly(in);
            }
        }
        return keys;
    }

    public void updateCacheSize(long keys) {
        int cacheSize;
        if (!this.isCapacitySetManually() && (cacheSize = this.getAdjustedCacheSize(keys)) != this.getCapacity()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)((Object)this.cacheType) + " capacity for " + this.cfName + " is " + cacheSize);
            }
            this.updateCapacity(cacheSize);
        }
    }

    public void reduceCacheSize() {
        if (this.getCapacity() > 0) {
            int newCapacity = (int)(DatabaseDescriptor.getReduceCacheCapacityTo() * (double)this.size());
            logger.warn(String.format("Reducing %s %s capacity from %d to %s to reduce memory pressure", new Object[]{this.cfName, this.cacheType, this.getCapacity(), newCapacity}));
            this.setCapacity(newCapacity);
        }
    }

    public class Writer
    implements CompactionInfo.Holder {
        private final Set<K> keys;
        private final CompactionInfo info;
        private final long estimatedTotalBytes;
        private long bytesWritten;

        private Writer(String ksname, String cfname) {
            this.keys = AutoSavingCache.this.getKeySet();
            long bytes = 0L;
            for (Object key : this.keys) {
                bytes += (long)AutoSavingCache.this.translateKey(key).remaining();
            }
            this.estimatedTotalBytes = bytes;
            CompactionType type = AutoSavingCache.this.cacheType.equals((Object)ColumnFamilyStore.CacheType.KEY_CACHE_TYPE) ? CompactionType.KEY_CACHE_SAVE : (AutoSavingCache.this.cacheType.equals((Object)ColumnFamilyStore.CacheType.ROW_CACHE_TYPE) ? CompactionType.ROW_CACHE_SAVE : CompactionType.UNKNOWN);
            this.info = new CompactionInfo(ksname, cfname, type, 0L, this.estimatedTotalBytes);
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            long bytesWritten = this.bytesWritten;
            return this.info.forProgress(bytesWritten, Math.max(bytesWritten, this.estimatedTotalBytes));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveCache() throws IOException {
            long start = System.currentTimeMillis();
            File path = AutoSavingCache.this.getCachePath();
            if (this.keys.size() == 0 || this.estimatedTotalBytes == 0L) {
                logger.debug("Deleting {} (cache is empty)");
                path.delete();
                return;
            }
            logger.debug("Saving {}", (Object)path);
            File tmpFile = File.createTempFile(path.getName(), null, path.getParentFile());
            BufferedRandomAccessFile out = new BufferedRandomAccessFile(tmpFile, "rw", 65535, true);
            try {
                for (Object key : this.keys) {
                    ByteBuffer bytes = AutoSavingCache.this.translateKey(key);
                    ByteBufferUtil.writeWithLength(bytes, out);
                    this.bytesWritten += (long)bytes.remaining();
                }
            }
            finally {
                out.close();
            }
            path.delete();
            if (!tmpFile.renameTo(path)) {
                throw new IOException("Unable to rename " + tmpFile + " to " + path);
            }
            logger.info(String.format("Saved %s (%d items) in %d ms", path.getName(), this.keys.size(), System.currentTimeMillis() - start));
        }
    }
}

