/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class ColumnFamilySplit
extends InputSplit
implements Writable {
    private String startToken;
    private String endToken;
    private String[] dataNodes;

    public ColumnFamilySplit(String startToken, String endToken, String[] dataNodes) {
        assert (startToken != null);
        assert (endToken != null);
        this.startToken = startToken;
        this.endToken = endToken;
        this.dataNodes = dataNodes;
    }

    public String getStartToken() {
        return this.startToken;
    }

    public String getEndToken() {
        return this.endToken;
    }

    public long getLength() {
        return Long.MAX_VALUE;
    }

    public String[] getLocations() {
        return this.dataNodes;
    }

    protected ColumnFamilySplit() {
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.startToken);
        out.writeUTF(this.endToken);
        out.writeInt(this.dataNodes.length);
        for (String endpoint : this.dataNodes) {
            out.writeUTF(endpoint);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.startToken = in.readUTF();
        this.endToken = in.readUTF();
        int numOfEndpoints = in.readInt();
        this.dataNodes = new String[numOfEndpoints];
        for (int i = 0; i < numOfEndpoints; ++i) {
            this.dataNodes[i] = in.readUTF();
        }
    }

    public String toString() {
        return "ColumnFamilySplit{startToken='" + this.startToken + '\'' + ", endToken='" + this.endToken + '\'' + ", dataNodes=" + (this.dataNodes == null ? null : Arrays.asList(this.dataNodes)) + '}';
    }

    public static ColumnFamilySplit read(DataInput in) throws IOException {
        ColumnFamilySplit w = new ColumnFamilySplit();
        w.readFields(in);
        return w;
    }
}

