/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractUUIDType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.commons.lang.time.DateUtils;

public class UUIDType
extends AbstractUUIDType {
    public static final UUIDType instance = new UUIDType();

    UUIDType() {
    }

    @Override
    public int compare(ByteBuffer b1, ByteBuffer b2) {
        int c;
        if (b1 == null || b1.remaining() < 16) {
            return b2 == null || b2.remaining() < 16 ? 0 : -1;
        }
        if (b2 == null || b2.remaining() < 16) {
            return 1;
        }
        int s1 = b1.arrayOffset() + b1.position();
        byte[] o1 = b1.array();
        int s2 = b2.arrayOffset() + b2.position();
        byte[] o2 = b2.array();
        if (o1.length == s1) {
            return o2.length == s2 ? 0 : -1;
        }
        if (o2.length == s2) {
            return 1;
        }
        int v1 = o1[s1 + 6] >> 4 & 0xF;
        int v2 = o2[s2 + 6] >> 4 & 0xF;
        if (v1 != v2) {
            return v1 - v2;
        }
        if (v1 == 1 && (c = UUIDType.compareTimestampBytes(s1, o1, s2, o2)) != 0) {
            return c;
        }
        for (int i = 0; i < 16; ++i) {
            int c2 = (o1[s1 + i] & 0xFF) - (o2[s2 + i] & 0xFF);
            if (c2 == 0) continue;
            return c2;
        }
        return 0;
    }

    private static int compareTimestampBytes(int s1, byte[] o1, int s2, byte[] o2) {
        int d = (o1[s1 + 6] & 0xF) - (o2[s2 + 6] & 0xF);
        if (d != 0) {
            return d;
        }
        d = (o1[s1 + 7] & 0xFF) - (o2[s2 + 7] & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1[s1 + 4] & 0xFF) - (o2[s2 + 4] & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1[s1 + 5] & 0xFF) - (o2[s2 + 5] & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1[s1 + 0] & 0xFF) - (o2[s2 + 0] & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1[s1 + 1] & 0xFF) - (o2[s2 + 1] & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1[s1 + 2] & 0xFF) - (o2[s2 + 2] & 0xFF);
        if (d != 0) {
            return d;
        }
        return (o1[s1 + 3] & 0xFF) - (o2[s2 + 3] & 0xFF);
    }

    @Override
    public UUID compose(ByteBuffer bytes) {
        if ((bytes = bytes.slice()).remaining() < 16) {
            return new UUID(0L, 0L);
        }
        return new UUID(bytes.getLong(), bytes.getLong());
    }

    @Override
    public String toString(UUID uuid) {
        return uuid.toString();
    }

    @Override
    public Class<UUID> getType() {
        return UUID.class;
    }

    @Override
    public void validate(ByteBuffer bytes) {
        if (bytes.remaining() != 0 && bytes.remaining() != 16) {
            throw new MarshalException("UUIDs must be exactly 16 bytes");
        }
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 16) {
            throw new MarshalException("UUIDs must be exactly 16 bytes");
        }
        UUID uuid = this.compose(bytes);
        return uuid.toString();
    }

    @Override
    public ByteBuffer decompose(UUID value) {
        return ByteBuffer.wrap(UUIDGen.decompose(value));
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer idBytes = null;
        if (TimeUUIDType.regexPattern.matcher(source).matches()) {
            try {
                UUID uuid = UUID.fromString(source);
                idBytes = ByteBuffer.wrap(UUIDGen.decompose(uuid));
            }
            catch (IllegalArgumentException e) {
                throw new MarshalException(String.format("unable to make UUID from '%s'", source), e);
            }
        }
        if (source.toLowerCase().equals("now")) {
            idBytes = ByteBuffer.wrap(UUIDGen.decompose(UUIDGen.makeType1UUIDFromHost(FBUtilities.getLocalAddress())));
        } else {
            if (source.matches("^\\d+$")) {
                try {
                    idBytes = ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes(Long.parseLong(source)));
                }
                catch (NumberFormatException e) {
                    throw new MarshalException(String.format("unable to make version 1 UUID from '%s'", source), e);
                }
            }
            try {
                long timestamp = DateUtils.parseDate((String)source, (String[])TimeUUIDType.iso8601Patterns).getTime();
                idBytes = ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes(timestamp));
            }
            catch (ParseException e1) {
                throw new MarshalException(String.format("unable to coerce '%s' to version 1 UUID", source), e1);
            }
        }
        return idBytes;
    }
}

