/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataOutput;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CompactionManagerMBean;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.io.AbstractCompactedRow;
import org.apache.cassandra.io.CompactionController;
import org.apache.cassandra.io.CompactionInfo;
import org.apache.cassandra.io.CompactionIterator;
import org.apache.cassandra.io.CompactionType;
import org.apache.cassandra.io.LazilyCompactedRow;
import org.apache.cassandra.io.PrecompactedRow;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.AntiEntropyService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.OperationType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NodeId;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.iterators.CollatingIterator;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.lang.StringUtils;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionManager
implements CompactionManagerMBean {
    public static final String MBEAN_OBJECT_NAME = "org.apache.cassandra.db:type=CompactionManager";
    private static final Logger logger = LoggerFactory.getLogger(CompactionManager.class);
    public static final CompactionManager instance = new CompactionManager();
    private final ReentrantReadWriteLock compactionLock = new ReentrantReadWriteLock();
    private CompactionExecutor executor = new CompactionExecutor();
    private Map<ColumnFamilyStore, Integer> estimatedCompactions = new NonBlockingHashMap();

    public Lock getCompactionLock() {
        return this.compactionLock.writeLock();
    }

    public Future<Integer> submitMinorIfNeeded(final ColumnFamilyStore cfs) {
        Callable<Integer> callable = new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Integer call() throws IOException {
                CompactionManager.this.compactionLock.readLock().lock();
                try {
                    if (cfs.isInvalid()) {
                        Integer n = 0;
                        return n;
                    }
                    Integer minThreshold = cfs.getMinimumCompactionThreshold();
                    Integer maxThreshold = cfs.getMaximumCompactionThreshold();
                    if (minThreshold == 0 || maxThreshold == 0) {
                        logger.debug("Compaction is currently disabled.");
                        Integer n = 0;
                        return n;
                    }
                    logger.debug("Checking to see if compaction of " + cfs.columnFamily + " would be useful");
                    Set buckets = CompactionManager.getBuckets(CompactionManager.convertSSTablesToPairs(cfs.getSSTables()), 0x3200000L);
                    CompactionManager.this.updateEstimateFor(cfs, buckets);
                    int gcBefore = cfs.isIndex() ? Integer.MAX_VALUE : CompactionManager.getDefaultGcBefore(cfs);
                    for (List<SSTableReader> list : buckets) {
                        if (list.size() < minThreshold) continue;
                        Collections.sort(list);
                        Set<SSTableReader> tocompact = cfs.getDataTracker().markCompacting(list, minThreshold, maxThreshold);
                        if (tocompact == null) continue;
                        try {
                            Integer n = CompactionManager.this.doCompaction(cfs, tocompact, gcBefore);
                            cfs.getDataTracker().unmarkCompacting(tocompact);
                            return n;
                        }
                        catch (Throwable throwable) {
                            try {
                                cfs.getDataTracker().unmarkCompacting(tocompact);
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throw throwable2;
                                return 0;
                            }
                        }
                    }
                }
                finally {
                    CompactionManager.this.compactionLock.readLock().unlock();
                }
            }
        };
        return this.executor.submit(callable);
    }

    private void updateEstimateFor(ColumnFamilyStore cfs, Set<List<SSTableReader>> buckets) {
        Integer minThreshold = cfs.getMinimumCompactionThreshold();
        Integer maxThreshold = cfs.getMaximumCompactionThreshold();
        if (minThreshold > 0 && maxThreshold > 0) {
            int n = 0;
            for (List<SSTableReader> sstables : buckets) {
                if (sstables.size() < minThreshold) continue;
                n = (int)((double)n + Math.ceil((double)sstables.size() / (double)maxThreshold.intValue()));
            }
            this.estimatedCompactions.put(cfs, n);
        } else {
            logger.debug("Compaction is currently disabled.");
        }
    }

    public void performCleanup(final ColumnFamilyStore cfStore, final NodeId.OneShotRenewer renewer) throws InterruptedException, ExecutionException {
        Callable<Object> runnable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.writeLock().lock();
                try {
                    if (cfStore.isInvalid()) {
                        2 var1_1 = this;
                        return var1_1;
                    }
                    Set<SSTableReader> tocleanup = cfStore.getDataTracker().markCompacting(cfStore.getSSTables(), 1, Integer.MAX_VALUE);
                    if (tocleanup == null || tocleanup.isEmpty()) {
                        2 var2_3 = this;
                        return var2_3;
                    }
                    try {
                        CompactionManager.this.compactionLock.readLock().lock();
                        CompactionManager.this.compactionLock.writeLock().unlock();
                        try {
                            CompactionManager.this.doCleanupCompaction(cfStore, tocleanup, renewer);
                        }
                        finally {
                            CompactionManager.this.compactionLock.readLock().unlock();
                        }
                    }
                    finally {
                        cfStore.getDataTracker().unmarkCompacting(tocleanup);
                    }
                    2 var2_4 = this;
                    return var2_4;
                }
                finally {
                    if (CompactionManager.this.compactionLock.writeLock().isHeldByCurrentThread()) {
                        CompactionManager.this.compactionLock.writeLock().unlock();
                    }
                }
            }
        };
        this.executor.submit(runnable).get();
    }

    public void performScrub(final ColumnFamilyStore cfStore) throws InterruptedException, ExecutionException {
        Callable<Object> runnable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.writeLock().lock();
                try {
                    if (cfStore.isInvalid()) {
                        3 var1_1 = this;
                        return var1_1;
                    }
                    Set<SSTableReader> toscrub = cfStore.getDataTracker().markCompacting(cfStore.getSSTables(), 1, Integer.MAX_VALUE);
                    if (toscrub == null || toscrub.isEmpty()) {
                        3 var2_3 = this;
                        return var2_3;
                    }
                    try {
                        CompactionManager.this.compactionLock.readLock().lock();
                        CompactionManager.this.compactionLock.writeLock().unlock();
                        try {
                            CompactionManager.this.doScrub(cfStore, toscrub);
                        }
                        finally {
                            CompactionManager.this.compactionLock.readLock().unlock();
                        }
                    }
                    finally {
                        cfStore.getDataTracker().unmarkCompacting(toscrub);
                    }
                    3 var2_4 = this;
                    return var2_4;
                }
                finally {
                    if (CompactionManager.this.compactionLock.writeLock().isHeldByCurrentThread()) {
                        CompactionManager.this.compactionLock.writeLock().unlock();
                    }
                }
            }
        };
        this.executor.submit(runnable).get();
    }

    public void performMajor(ColumnFamilyStore cfStore) throws InterruptedException, ExecutionException {
        this.submitMajor(cfStore, 0L, CompactionManager.getDefaultGcBefore(cfStore)).get();
    }

    public Future<Object> submitMajor(final ColumnFamilyStore cfStore, final long skip, final int gcBefore) {
        Callable<Object> callable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.writeLock().lock();
                try {
                    4 var3_4;
                    Set<SSTableReader> tocompact;
                    ArrayList<SSTableReader> sstables;
                    if (cfStore.isInvalid()) {
                        4 var1_1 = this;
                        return var1_1;
                    }
                    if (skip > 0L) {
                        sstables = new ArrayList();
                        for (SSTableReader sstable : cfStore.getSSTables()) {
                            if (sstable.length() >= skip * 1024L * 1024L * 1024L) continue;
                            sstables.add(sstable);
                        }
                    } else {
                        sstables = cfStore.getSSTables();
                    }
                    if ((tocompact = cfStore.getDataTracker().markCompacting(sstables, 0, Integer.MAX_VALUE)) == null || tocompact.isEmpty()) {
                        var3_4 = this;
                        return var3_4;
                    }
                    try {
                        CompactionManager.this.compactionLock.readLock().lock();
                        CompactionManager.this.compactionLock.writeLock().unlock();
                        try {
                            CompactionManager.this.doCompaction(cfStore, tocompact, gcBefore);
                        }
                        finally {
                            CompactionManager.this.compactionLock.readLock().unlock();
                        }
                    }
                    finally {
                        cfStore.getDataTracker().unmarkCompacting(tocompact);
                    }
                    var3_4 = this;
                    return var3_4;
                }
                finally {
                    if (CompactionManager.this.compactionLock.writeLock().isHeldByCurrentThread()) {
                        CompactionManager.this.compactionLock.writeLock().unlock();
                    }
                }
            }
        };
        return this.executor.submit(callable);
    }

    @Override
    public void forceUserDefinedCompaction(String ksname, String dataFiles) {
        if (!DatabaseDescriptor.getTables().contains(ksname)) {
            throw new IllegalArgumentException("Unknown keyspace " + ksname);
        }
        File directory = new File(ksname);
        String[] filenames = dataFiles.split(",");
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(filenames.length);
        String cfname = null;
        for (String filename : filenames) {
            Pair<Descriptor, String> p = Descriptor.fromFilename(directory, filename.trim());
            if (!((String)p.right).equals(Component.DATA.name())) {
                throw new IllegalArgumentException(filename + " does not appear to be a data file");
            }
            if (cfname == null) {
                cfname = ((Descriptor)p.left).cfname;
            } else if (!cfname.equals(((Descriptor)p.left).cfname)) {
                throw new IllegalArgumentException("All provided sstables should be for the same column family");
            }
            descriptors.add((Descriptor)p.left);
        }
        ColumnFamilyStore cfs = Table.open(ksname).getColumnFamilyStore(cfname);
        this.submitUserDefined(cfs, descriptors, CompactionManager.getDefaultGcBefore(cfs));
    }

    public Future<Object> submitUserDefined(final ColumnFamilyStore cfs, final Collection<Descriptor> dataFiles, final int gcBefore) {
        Callable<Object> callable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.readLock().lock();
                try {
                    if (cfs.isInvalid()) {
                        5 var1_1 = this;
                        return var1_1;
                    }
                    Collection<SSTableReader> sstables = new ArrayList<SSTableReader>();
                    for (Descriptor desc : dataFiles) {
                        SSTableReader sstable = CompactionManager.this.lookupSSTable(cfs, desc);
                        if (sstable == null) {
                            logger.info("Will not compact {}: it is not an active sstable", (Object)desc);
                            continue;
                        }
                        sstables.add(sstable);
                    }
                    if (sstables.isEmpty()) {
                        logger.error("No file to compact for user defined compaction");
                    } else {
                        sstables = cfs.getDataTracker().markCompacting(sstables, 1, Integer.MAX_VALUE);
                        if (sstables != null) {
                            String location = cfs.table.getDataFileLocation(1L);
                            try {
                                CompactionManager.this.doCompactionWithoutSizeEstimation(cfs, sstables, gcBefore, location);
                            }
                            finally {
                                cfs.getDataTracker().unmarkCompacting(sstables);
                            }
                        } else {
                            logger.error("SSTables for user defined compaction are already being compacted.");
                        }
                    }
                    5 var2_3 = this;
                    return var2_3;
                }
                finally {
                    CompactionManager.this.compactionLock.readLock().unlock();
                }
            }
        };
        return this.executor.submit(callable);
    }

    private SSTableReader lookupSSTable(ColumnFamilyStore cfs, Descriptor descriptor) {
        for (SSTableReader sstable : cfs.getSSTables()) {
            if (!sstable.descriptor.toString().endsWith(descriptor.toString())) continue;
            return sstable;
        }
        return null;
    }

    public Future<Object> submitValidation(final ColumnFamilyStore cfStore, final AntiEntropyService.Validator validator) {
        Callable<Object> callable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws IOException {
                CompactionManager.this.compactionLock.readLock().lock();
                try {
                    if (!cfStore.isInvalid()) {
                        CompactionManager.this.doValidationCompaction(cfStore, validator);
                    }
                    6 var1_1 = this;
                    return var1_1;
                }
                finally {
                    CompactionManager.this.compactionLock.readLock().unlock();
                }
            }
        };
        return this.executor.submit(callable);
    }

    public void disableAutoCompaction() {
        for (String ksname : DatabaseDescriptor.getNonSystemTables()) {
            for (ColumnFamilyStore cfs : Table.open(ksname).getColumnFamilyStores()) {
                cfs.disableAutoCompaction();
            }
        }
    }

    int doCompaction(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int gcBefore) throws IOException {
        Table table = cfs.table;
        HashSet<SSTableReader> smallerSSTables = new HashSet<SSTableReader>(sstables);
        while (smallerSSTables.size() > 1) {
            String compactionFileLocation = table.getDataFileLocation(cfs.getExpectedCompactedFileSize(smallerSSTables));
            if (compactionFileLocation != null) {
                return this.doCompactionWithoutSizeEstimation(cfs, smallerSSTables, gcBefore, compactionFileLocation);
            }
            logger.warn("insufficient space to compact all requested files " + StringUtils.join(smallerSSTables, (String)", "));
            smallerSSTables.remove(cfs.getMaxSizeFile(smallerSSTables));
        }
        logger.error("insufficient space to compact even the two smallest files, aborting");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doCompactionWithoutSizeEstimation(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int gcBefore, String compactionFileLocation) throws IOException {
        SSTableWriter writer;
        assert (sstables != null);
        Table table = cfs.table;
        if (DatabaseDescriptor.isSnapshotBeforeCompaction()) {
            table.snapshot(System.currentTimeMillis() + "-" + "compact-" + cfs.columnFamily);
        }
        for (SSTableReader sstable : sstables) {
            assert (sstable.descriptor.cfname.equals(cfs.columnFamily));
        }
        boolean major = cfs.isCompleteSSTables(sstables);
        CompactionType type = major ? CompactionType.MAJOR : CompactionType.MINOR;
        logger.info("Compacting {}: {}", (Object)type, sstables);
        long startTime = System.currentTimeMillis();
        long totalkeysWritten = 0L;
        int expectedBloomFilterSize = Math.max(DatabaseDescriptor.getIndexInterval(), (int)SSTableReader.getApproximateKeyCount(sstables));
        if (logger.isDebugEnabled()) {
            logger.debug("Expected bloom filter size : " + expectedBloomFilterSize);
        }
        CompactionController controller = new CompactionController(cfs, sstables, major, gcBefore, false);
        CompactionIterator ci = new CompactionIterator(type, sstables, controller);
        FilterIterator nni = new FilterIterator((Iterator)ci, PredicateUtils.notNullPredicate());
        HashMap<DecoratedKey, Long> cachedKeys = new HashMap<DecoratedKey, Long>();
        this.executor.beginCompaction(ci);
        try {
            if (!nni.hasNext()) {
                cfs.markCompacted(sstables);
                int n = 0;
                return n;
            }
            writer = cfs.createCompactionWriter(expectedBloomFilterSize, compactionFileLocation, sstables);
            block5: while (nni.hasNext()) {
                AbstractCompactedRow row = (AbstractCompactedRow)nni.next();
                long position = writer.append(row);
                ++totalkeysWritten;
                if (!DatabaseDescriptor.getPreheatKeyCache()) continue;
                for (SSTableReader sstable : sstables) {
                    if (sstable.getCachedPosition(row.key) == null) continue;
                    cachedKeys.put(row.key, position);
                    continue block5;
                }
            }
        }
        finally {
            ci.close();
            this.executor.finishCompaction(ci);
        }
        SSTableReader ssTable = writer.closeAndOpenReader(CompactionManager.getMaxDataAge(sstables));
        cfs.replaceCompactedSSTables(sstables, Arrays.asList(ssTable));
        for (Map.Entry entry : cachedKeys.entrySet()) {
            ssTable.cacheKey((DecoratedKey)entry.getKey(), (Long)entry.getValue());
        }
        this.submitMinorIfNeeded(cfs);
        long dTime = System.currentTimeMillis() - startTime;
        long startsize = SSTable.getTotalBytes(sstables);
        long endsize = ssTable.length();
        double ratio = (double)endsize / (double)startsize;
        logger.info(String.format("Compacted to %s.  %,d to %,d (~%d%% of original) bytes for %,d keys.  Time: %,dms.", writer.getFilename(), startsize, endsize, (int)(ratio * 100.0), totalkeysWritten, dTime));
        return sstables.size();
    }

    private static long getMaxDataAge(Collection<SSTableReader> sstables) {
        long max = 0L;
        for (SSTableReader sstable : sstables) {
            if (sstable.maxDataAge <= max) continue;
            max = sstable.maxDataAge;
        }
        return max;
    }

    private void doScrub(ColumnFamilyStore cfs, Collection<SSTableReader> sstables) throws IOException {
        assert (!cfs.isIndex());
        for (SSTableReader sstable : sstables) {
            logger.info("Scrubbing " + sstable);
            String compactionFileLocation = cfs.table.getDataFileLocation(sstable.length());
            if (compactionFileLocation == null) {
                throw new IOException("disk full");
            }
            int expectedBloomFilterSize = Math.max(DatabaseDescriptor.getIndexInterval(), (int)SSTableReader.getApproximateKeyCount(Arrays.asList(sstable)));
            BufferedRandomAccessFile dataFile = BufferedRandomAccessFile.getUncachingReader(sstable.getFilename());
            String indexFilename = sstable.descriptor.filenameFor(Component.PRIMARY_INDEX);
            BufferedRandomAccessFile indexFile = BufferedRandomAccessFile.getUncachingReader(indexFilename);
            ByteBuffer nextIndexKey = ByteBufferUtil.readWithShortLength(indexFile);
            long firstRowPositionFromIndex = indexFile.readLong();
            assert (firstRowPositionFromIndex == 0L) : firstRowPositionFromIndex;
            SSTableWriter writer = this.maybeCreateWriter(cfs, compactionFileLocation, expectedBloomFilterSize, null, Collections.singletonList(sstable));
            this.executor.beginCompaction(new ScrubInfo(dataFile, sstable));
            int goodRows = 0;
            int badRows = 0;
            int emptyRows = 0;
            while (!dataFile.isEOF()) {
                long nextRowPositionFromIndex;
                long rowStart = dataFile.getFilePointer();
                if (logger.isDebugEnabled()) {
                    logger.debug("Reading row at " + rowStart);
                }
                DecoratedKey key = null;
                long dataSize = -1L;
                try {
                    key = SSTableReader.decodeKey(sstable.partitioner, sstable.descriptor, ByteBufferUtil.readWithShortLength(dataFile));
                    long l = dataSize = sstable.descriptor.hasIntRowSize ? (long)dataFile.readInt() : dataFile.readLong();
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("row %s is %s bytes", ByteBufferUtil.bytesToHex(key.key), dataSize));
                    }
                }
                catch (Throwable th) {
                    this.throwIfFatal(th);
                }
                ByteBuffer currentIndexKey = nextIndexKey;
                try {
                    nextIndexKey = indexFile.isEOF() ? null : ByteBufferUtil.readWithShortLength(indexFile);
                    nextRowPositionFromIndex = indexFile.isEOF() ? dataFile.length() : indexFile.readLong();
                }
                catch (Throwable th) {
                    logger.warn("Error reading index file", th);
                    nextIndexKey = null;
                    nextRowPositionFromIndex = dataFile.length();
                }
                long dataStart = dataFile.getFilePointer();
                long dataStartFromIndex = currentIndexKey == null ? -1L : rowStart + 2L + (long)currentIndexKey.remaining() + (long)(sstable.descriptor.hasIntRowSize ? 4 : 8);
                long dataSizeFromIndex = nextRowPositionFromIndex - dataStartFromIndex;
                assert (currentIndexKey != null || indexFile.isEOF());
                if (logger.isDebugEnabled() && currentIndexKey != null) {
                    logger.debug(String.format("Index doublecheck: row %s is %s bytes", ByteBufferUtil.bytesToHex(currentIndexKey), dataSizeFromIndex));
                }
                writer.mark();
                try {
                    if (key == null) {
                        throw new IOError(new IOException("Unable to read row key from data file"));
                    }
                    if (dataSize > dataFile.length()) {
                        throw new IOError(new IOException("Impossible row size " + dataSize));
                    }
                    SSTableIdentityIterator row = new SSTableIdentityIterator(sstable, dataFile, key, dataStart, dataSize, true);
                    AbstractCompactedRow compactedRow = this.getCompactedRow(row, sstable.descriptor, true);
                    if (compactedRow.isEmpty()) {
                        ++emptyRows;
                    } else {
                        writer.append(compactedRow);
                        ++goodRows;
                    }
                    if (key.key.equals(currentIndexKey) && dataStart == dataStartFromIndex) continue;
                    logger.warn("Row scrubbed successfully but index file contains a different key or row size; consider rebuilding the index as described in http://www.mail-archive.com/user@cassandra.apache.org/msg03325.html");
                }
                catch (Throwable th) {
                    this.throwIfFatal(th);
                    logger.warn("Non-fatal error reading row (stacktrace follows)", th);
                    writer.reset();
                    if (!(currentIndexKey == null || key != null && key.key.equals(currentIndexKey) && dataStart == dataStartFromIndex && dataSize == dataSizeFromIndex)) {
                        logger.info(String.format("Retrying from row index; data is %s bytes starting at %s", dataSizeFromIndex, dataStartFromIndex));
                        key = SSTableReader.decodeKey(sstable.partitioner, sstable.descriptor, currentIndexKey);
                        try {
                            SSTableIdentityIterator row = new SSTableIdentityIterator(sstable, dataFile, key, dataStartFromIndex, dataSizeFromIndex, true);
                            AbstractCompactedRow compactedRow = this.getCompactedRow(row, sstable.descriptor, true);
                            if (compactedRow.isEmpty()) {
                                ++emptyRows;
                                continue;
                            }
                            writer.append(compactedRow);
                            ++goodRows;
                        }
                        catch (Throwable th2) {
                            this.throwIfFatal(th2);
                            logger.warn("Retry failed too.  Skipping to next row (retry's stacktrace follows)", th2);
                            writer.reset();
                            dataFile.seek(nextRowPositionFromIndex);
                            ++badRows;
                        }
                        continue;
                    }
                    logger.warn("Row at " + dataStart + " is unreadable; skipping to next");
                    if (currentIndexKey != null) {
                        dataFile.seek(nextRowPositionFromIndex);
                    }
                    ++badRows;
                }
            }
            if (writer.getFilePointer() > 0L) {
                SSTableReader newSstable = writer.closeAndOpenReader(sstable.maxDataAge);
                cfs.replaceCompactedSSTables(Arrays.asList(sstable), Arrays.asList(newSstable));
                logger.info("Scrub of " + sstable + " complete: " + goodRows + " rows in new sstable and " + emptyRows + " empty (tombstoned) rows dropped");
                if (badRows <= 0) continue;
                logger.warn("Unable to recover " + badRows + " rows that were skipped.  You can attempt manual recovery from the pre-scrub snapshot.  You can also run nodetool repair to transfer the data from a healthy replica, if any");
                continue;
            }
            cfs.markCompacted(Arrays.asList(sstable));
            if (badRows > 0) {
                logger.warn("No valid rows found while scrubbing " + sstable + "; it is marked for deletion now. If you want to attempt manual recovery, you can find a copy in the pre-scrub snapshot");
                continue;
            }
            logger.info("Scrub of " + sstable + " complete; looks like all " + emptyRows + " rows were tombstoned");
        }
    }

    private void throwIfFatal(Throwable th) {
        if (th instanceof Error && !(th instanceof AssertionError) && !(th instanceof IOError)) {
            throw (Error)th;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanupCompaction(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, NodeId.OneShotRenewer renewer) throws IOException {
        assert (!cfs.isIndex());
        Table table = cfs.table;
        Collection<Range> ranges = StorageService.instance.getLocalRanges(table.name);
        boolean isCommutative = cfs.metadata.getDefaultValidator().isCommutative();
        if (ranges.isEmpty()) {
            logger.info("Cleanup cannot run before a node has joined the ring");
            return;
        }
        for (SSTableReader sstable : sstables) {
            long startTime = System.currentTimeMillis();
            long totalkeysWritten = 0L;
            int expectedBloomFilterSize = Math.max(DatabaseDescriptor.getIndexInterval(), (int)SSTableReader.getApproximateKeyCount(Arrays.asList(sstable)));
            if (logger.isDebugEnabled()) {
                logger.debug("Expected bloom filter size : " + expectedBloomFilterSize);
            }
            SSTableWriter writer = null;
            try {
                logger.info("Cleaning up " + sstable);
                long expectedRangeFileSize = cfs.getExpectedCompactedFileSize(Arrays.asList(sstable)) / 2L;
                String compactionFileLocation = table.getDataFileLocation(expectedRangeFileSize);
                if (compactionFileLocation == null) {
                    throw new IOException("disk full");
                }
                SSTableScanner scanner = sstable.getDirectScanner(0x100000);
                SortedSet<ByteBuffer> indexedColumns = cfs.getIndexedColumns();
                CleanupInfo ci = new CleanupInfo(sstable, scanner);
                this.executor.beginCompaction(ci);
                try {
                    while (scanner.hasNext()) {
                        SSTableIdentityIterator row = (SSTableIdentityIterator)scanner.next();
                        if (Range.isTokenInRanges(row.getKey().token, ranges)) {
                            writer = this.maybeCreateWriter(cfs, compactionFileLocation, expectedBloomFilterSize, writer, Collections.singletonList(sstable));
                            writer.append(this.getCompactedRow(row, sstable.descriptor, false));
                            ++totalkeysWritten;
                            continue;
                        }
                        cfs.invalidateCachedRow(row.getKey());
                        if (indexedColumns.isEmpty() && !isCommutative) continue;
                        while (row.hasNext()) {
                            IColumn column = row.next();
                            if (column instanceof CounterColumn) {
                                renewer.maybeRenew((CounterColumn)column);
                            }
                            if (!indexedColumns.contains(column.name())) continue;
                            Table.cleanupIndexEntry(cfs, row.getKey().key, column);
                        }
                    }
                }
                finally {
                    scanner.close();
                    this.executor.finishCompaction(ci);
                }
            }
            catch (Throwable throwable) {
                cfs.getDataTracker().unmarkCompacting(Arrays.asList(sstable));
                throw throwable;
            }
            cfs.getDataTracker().unmarkCompacting(Arrays.asList(sstable));
            ArrayList<SSTableReader> results = new ArrayList<SSTableReader>();
            if (writer != null) {
                SSTableReader newSstable = writer.closeAndOpenReader(sstable.maxDataAge);
                results.add(newSstable);
                String format = "Cleaned up to %s.  %,d to %,d (~%d%% of original) bytes for %,d keys.  Time: %,dms.";
                long dTime = System.currentTimeMillis() - startTime;
                long startsize = sstable.length();
                long endsize = newSstable.length();
                double ratio = (double)endsize / (double)startsize;
                logger.info(String.format(format, writer.getFilename(), startsize, endsize, (int)(ratio * 100.0), totalkeysWritten, dTime));
            }
            for (ByteBuffer columnName : cfs.getIndexedColumns()) {
                try {
                    cfs.getIndexedColumnFamilyStore(columnName).forceBlockingFlush();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
            cfs.replaceCompactedSSTables(Arrays.asList(sstable), results);
        }
    }

    private AbstractCompactedRow getCompactedRow(SSTableIdentityIterator row, Descriptor descriptor, boolean forceDeserialize) {
        if (descriptor.isLatestVersion && !forceDeserialize) {
            return new EchoedRow(row);
        }
        return row.dataSize > (long)DatabaseDescriptor.getInMemoryCompactionLimit() ? new LazilyCompactedRow(CompactionController.getBasicController(forceDeserialize), Arrays.asList(row)) : new PrecompactedRow(CompactionController.getBasicController(forceDeserialize), Arrays.asList(row));
    }

    private SSTableWriter maybeCreateWriter(ColumnFamilyStore cfs, String compactionFileLocation, int expectedBloomFilterSize, SSTableWriter writer, Collection<SSTableReader> sstables) throws IOException {
        if (writer == null) {
            FileUtils.createDirectory(compactionFileLocation);
            writer = cfs.createCompactionWriter(expectedBloomFilterSize, compactionFileLocation, sstables);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidationCompaction(ColumnFamilyStore cfs, AntiEntropyService.Validator validator) throws IOException {
        try {
            StorageService.instance.forceTableFlush(cfs.table.name, cfs.getColumnFamilyName());
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        ValidationCompactionIterator ci = new ValidationCompactionIterator(cfs, validator.request.range);
        this.executor.beginCompaction(ci);
        try {
            FilterIterator nni = new FilterIterator((Iterator)ci, PredicateUtils.notNullPredicate());
            validator.prepare(cfs);
            while (nni.hasNext()) {
                AbstractCompactedRow row = (AbstractCompactedRow)nni.next();
                validator.add(row);
            }
            validator.complete();
        }
        finally {
            ci.close();
            this.executor.finishCompaction(ci);
        }
    }

    static <T> Set<List<T>> getBuckets(Collection<Pair<T, Long>> files, long min) {
        ArrayList<Pair<T, Long>> sortedFiles = new ArrayList<Pair<T, Long>>(files);
        Collections.sort(sortedFiles, new Comparator<Pair<T, Long>>(){

            @Override
            public int compare(Pair<T, Long> p1, Pair<T, Long> p2) {
                return ((Long)p1.right).compareTo((Long)p2.right);
            }
        });
        HashMap<List, Long> buckets = new HashMap<List, Long>();
        for (Pair pair : sortedFiles) {
            long size = (Long)pair.right;
            boolean bFound = false;
            for (Map.Entry entry : buckets.entrySet()) {
                List bucket = (List)entry.getKey();
                long averageSize = (Long)entry.getValue();
                if ((size <= averageSize / 2L || size >= 3L * averageSize / 2L) && (size >= min || averageSize >= min)) continue;
                buckets.remove(bucket);
                long totalSize = (long)bucket.size() * averageSize;
                averageSize = (totalSize + size) / (long)(bucket.size() + 1);
                bucket.add(pair.left);
                buckets.put(bucket, averageSize);
                bFound = true;
                break;
            }
            if (bFound) continue;
            ArrayList bucket = new ArrayList();
            bucket.add(pair.left);
            buckets.put(bucket, size);
        }
        return buckets.keySet();
    }

    private static Collection<Pair<SSTableReader, Long>> convertSSTablesToPairs(Collection<SSTableReader> collection) {
        ArrayList<Pair<SSTableReader, Long>> tablePairs = new ArrayList<Pair<SSTableReader, Long>>();
        for (SSTableReader table : collection) {
            tablePairs.add(new Pair<SSTableReader, Long>(table, table.length()));
        }
        return tablePairs;
    }

    public Future submitIndexBuild(final ColumnFamilyStore cfs, final Table.IndexBuilder builder) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompactionManager.this.compactionLock.readLock().lock();
                try {
                    if (cfs.isInvalid()) {
                        return;
                    }
                    CompactionManager.this.executor.beginCompaction(builder);
                    try {
                        builder.build();
                    }
                    finally {
                        CompactionManager.this.executor.finishCompaction(builder);
                    }
                }
                finally {
                    CompactionManager.this.compactionLock.readLock().unlock();
                }
            }
        };
        if (this.compactionLock.isWriteLockedByCurrentThread()) {
            return new SimpleFuture(runnable);
        }
        return this.executor.submit(runnable);
    }

    public Future<SSTableReader> submitSSTableBuild(Descriptor desc, OperationType type) {
        final SSTableWriter.Builder builder = SSTableWriter.createBuilder(desc, type);
        Callable<SSTableReader> callable = new Callable<SSTableReader>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SSTableReader call() throws IOException {
                CompactionManager.this.compactionLock.readLock().lock();
                try {
                    CompactionManager.this.executor.beginCompaction(builder);
                    try {
                        SSTableReader sSTableReader = builder.build();
                        CompactionManager.this.executor.finishCompaction(builder);
                        return sSTableReader;
                    }
                    catch (Throwable throwable) {
                        CompactionManager.this.executor.finishCompaction(builder);
                        throw throwable;
                    }
                }
                finally {
                    CompactionManager.this.compactionLock.readLock().unlock();
                }
            }
        };
        return this.executor.submit(callable);
    }

    public Future<?> submitCacheWrite(final AutoSavingCache.Writer writer) {
        WrappedRunnable runnable = new WrappedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runMayThrow() throws IOException {
                if (!AutoSavingCache.flushInProgress.compareAndSet(false, true)) {
                    logger.debug("Cache flushing was already in progress: skipping {}", (Object)writer.getCompactionInfo());
                    return;
                }
                try {
                    CompactionManager.this.executor.beginCompaction(writer);
                    try {
                        writer.saveCache();
                    }
                    finally {
                        CompactionManager.this.executor.finishCompaction(writer);
                    }
                }
                finally {
                    AutoSavingCache.flushInProgress.set(false);
                }
            }
        };
        return this.executor.submit(runnable);
    }

    private static int getDefaultGcBefore(ColumnFamilyStore cfs) {
        return (int)(System.currentTimeMillis() / 1000L) - cfs.metadata.getGcGraceSeconds();
    }

    public void checkAllColumnFamilies() throws IOException {
        for (final ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    logger.debug("Estimating compactions for " + cfs.columnFamily);
                    Set buckets = CompactionManager.getBuckets(CompactionManager.convertSSTablesToPairs(cfs.getSSTables()), 0x3200000L);
                    CompactionManager.this.updateEstimateFor(cfs, buckets);
                }
            };
            this.executor.submit(runnable);
        }
        for (final ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            this.submitMinorIfNeeded(cfs);
        }
    }

    public int getActiveCompactions() {
        return this.executor.getActiveCount();
    }

    @Override
    public List<CompactionInfo> getCompactions() {
        ArrayList<CompactionInfo> out = new ArrayList<CompactionInfo>();
        for (CompactionInfo.Holder ci : this.executor.getCompactions()) {
            out.add(ci.getCompactionInfo());
        }
        return out;
    }

    @Override
    public List<String> getCompactionSummary() {
        ArrayList<String> out = new ArrayList<String>();
        for (CompactionInfo.Holder ci : this.executor.getCompactions()) {
            out.add(ci.getCompactionInfo().toString());
        }
        return out;
    }

    @Override
    public int getPendingTasks() {
        int n = 0;
        for (Integer i : this.estimatedCompactions.values()) {
            n += i.intValue();
        }
        return (int)(this.executor.getTaskCount() - this.executor.getCompletedTaskCount()) + n;
    }

    @Override
    public long getCompletedTasks() {
        return this.executor.getCompletedTaskCount();
    }

    static {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(instance, new ObjectName(MBEAN_OBJECT_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class ScrubInfo
    implements CompactionInfo.Holder {
        private final BufferedRandomAccessFile dataFile;
        private final SSTableReader sstable;

        public ScrubInfo(BufferedRandomAccessFile dataFile, SSTableReader sstable) {
            this.dataFile = dataFile;
            this.sstable = sstable;
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            try {
                return new CompactionInfo(this.sstable.descriptor.ksname, this.sstable.descriptor.cfname, CompactionType.SCRUB, this.dataFile.getFilePointer(), this.dataFile.length());
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    private static class CleanupInfo
    implements CompactionInfo.Holder {
        private final SSTableReader sstable;
        private final SSTableScanner scanner;

        public CleanupInfo(SSTableReader sstable, SSTableScanner scanner) {
            this.sstable = sstable;
            this.scanner = scanner;
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            try {
                return new CompactionInfo(this.sstable.descriptor.ksname, this.sstable.descriptor.cfname, CompactionType.CLEANUP, this.scanner.getFilePointer(), this.scanner.getFileLength());
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    private static class EchoedRow
    extends AbstractCompactedRow {
        private final SSTableIdentityIterator row;

        public EchoedRow(SSTableIdentityIterator row) {
            super(row.getKey());
            this.row = row;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            assert (this.row.dataSize > 0L);
            out.writeLong(this.row.dataSize);
            this.row.echoData(out);
        }

        @Override
        public void update(MessageDigest digest) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return !this.row.hasNext();
        }

        @Override
        public int columnCount() {
            return this.row.columnCount;
        }
    }

    private static class SimpleFuture
    implements Future {
        private Runnable runnable;

        private SimpleFuture(Runnable r) {
            this.runnable = r;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new IllegalStateException("May not call SimpleFuture.cancel()");
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.runnable == null;
        }

        public Object get() throws InterruptedException, ExecutionException {
            this.runnable.run();
            this.runnable = null;
            return this.runnable;
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new IllegalStateException("May not call SimpleFuture.get(long, TimeUnit)");
        }
    }

    private static class CompactionExecutor
    extends DebuggableThreadPoolExecutor {
        private final Set<CompactionInfo.Holder> compactions;

        public CompactionExecutor() {
            super(CompactionExecutor.getThreadCount(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("CompactionExecutor", DatabaseDescriptor.getCompactionThreadPriority()));
            IdentityHashMap cmap = new IdentityHashMap();
            this.compactions = Collections.synchronizedSet(Collections.newSetFromMap(cmap));
        }

        private static int getThreadCount() {
            return Math.max(1, DatabaseDescriptor.getConcurrentCompactors());
        }

        void beginCompaction(CompactionInfo.Holder ci) {
            this.compactions.add(ci);
        }

        void finishCompaction(CompactionInfo.Holder ci) {
            this.compactions.remove(ci);
        }

        public List<CompactionInfo.Holder> getCompactions() {
            return new ArrayList<CompactionInfo.Holder>(this.compactions);
        }
    }

    private static class ValidationCompactionIterator
    extends CompactionIterator {
        public ValidationCompactionIterator(ColumnFamilyStore cfs, Range range) throws IOException {
            super(CompactionType.VALIDATION, (Iterator)ValidationCompactionIterator.getCollatingIterator(cfs.getSSTables(), range), new CompactionController(cfs, cfs.getSSTables(), true, CompactionManager.getDefaultGcBefore(cfs), false));
        }

        protected static CollatingIterator getCollatingIterator(Iterable<SSTableReader> sstables, Range range) throws IOException {
            CollatingIterator iter = FBUtilities.getCollatingIterator();
            for (SSTableReader sstable : sstables) {
                iter.addIterator((Iterator)sstable.getDirectScanner(0x100000, range));
            }
            return iter;
        }
    }
}

