/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import org.apache.cassandra.thrift.Compression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    Utils() {
    }

    public static ByteBuffer compressQuery(String queryStr, Compression compression) {
        byte[] data = queryStr.getBytes(Charsets.UTF_8);
        Deflater compressor = new Deflater();
        compressor.setInput(data);
        compressor.finish();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (!compressor.finished()) {
            int size = compressor.deflate(buffer);
            byteArray.write(buffer, 0, size);
        }
        logger.trace("Compressed query statement {} bytes in length to {} bytes", (Object)data.length, (Object)byteArray.size());
        return ByteBuffer.wrap(byteArray.toByteArray());
    }
}

