/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.thrift.Column;

class TypedColumn {
    private final Column rawColumn;
    private final Object value;
    private final String nameString;
    private final AbstractType nameType;
    private final AbstractType valueType;

    public TypedColumn(Column column, AbstractType comparator, AbstractType validator) {
        this.rawColumn = column;
        this.value = column.value == null ? null : validator.compose(column.value);
        this.nameString = comparator.getString(column.name);
        this.nameType = comparator;
        this.valueType = validator;
    }

    public Column getRawColumn() {
        return this.rawColumn;
    }

    public Object getValue() {
        return this.value;
    }

    public String getNameString() {
        return this.nameString;
    }

    public String getValueString() {
        return this.valueType.getString(this.rawColumn.value);
    }

    public AbstractType getNameType() {
        return this.nameType;
    }

    public AbstractType getValueType() {
        return this.valueType;
    }
}

