/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.cassandra.cql.jdbc.Connection;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionPool {
    public static final int DEFAULT_MAX_CONNECTIONS = 25;
    public static final int DEFAULT_PORT = 9160;
    public static final int DEFAULT_MAX_IDLE = 5;
    public static final long DEFAULT_EVICTION_DELAY_MILLIS = 10000L;
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPool.class);
    private ConcurrentLinkedQueue<Connection> connections = new ConcurrentLinkedQueue();
    private Timer eviction;
    private String hostName;
    private int portNo;
    private int maxConns;
    private int maxIdle;

    public ConnectionPool(String hostName) throws TTransportException {
        this(hostName, 9160, 25, 5, 10000L);
    }

    public ConnectionPool(String hostName, int portNo) throws TTransportException {
        this(hostName, portNo, 25, 5, 10000L);
    }

    public ConnectionPool(String hostName, int portNo, int maxConns, int maxIdle, long evictionDelay) throws TTransportException {
        this.hostName = hostName;
        this.portNo = portNo;
        this.maxConns = maxConns;
        this.maxIdle = maxIdle;
        this.eviction = new Timer("EVICTION-THREAD", true);
        this.eviction.schedule((TimerTask)new EvictionTask(), new Date(), evictionDelay);
        this.connections.add(new Connection(hostName, portNo));
    }

    public Connection borrowConnection() {
        Connection conn = null;
        conn = this.connections.poll();
        if (conn == null) {
            try {
                conn = new Connection(this.hostName, this.portNo);
            }
            catch (TTransportException error) {
                logger.error(String.format("Error connecting to %s:%s", this.hostName, this.portNo), (Throwable)error);
            }
        }
        return conn;
    }

    public void returnConnection(Connection connection) {
        if (this.connections.size() >= this.maxConns) {
            if (connection.isOpen()) {
                connection.close();
            }
            logger.warn("Max pool size reached; Connection discarded.");
            return;
        }
        if (!connection.isOpen()) {
            logger.warn("Stubbornly refusing to return a closed connection to the pool (discarded instead).");
            return;
        }
        this.connections.add(connection);
    }

    private class EvictionTask
    extends TimerTask {
        private EvictionTask() {
        }

        @Override
        public void run() {
            int count = 0;
            while (ConnectionPool.this.connections.size() > ConnectionPool.this.maxIdle) {
                Connection conn = (Connection)ConnectionPool.this.connections.poll();
                if (conn.isOpen()) {
                    conn.close();
                }
                ++count;
            }
            if (count > 0) {
                logger.debug("Eviction run complete: {} connections evicted.", (Object)count);
            }
        }
    }
}

