/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql.jdbc.TypedColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ColumnDecoder {
    private static final Logger logger = LoggerFactory.getLogger(ColumnDecoder.class);
    private final Map<String, CFMetaData> metadata = new HashMap<String, CFMetaData>();

    public ColumnDecoder(List<KsDef> defs) {
        for (KsDef ks : defs) {
            for (CfDef cf : ks.getCf_defs()) {
                try {
                    this.metadata.put(String.format("%s.%s", ks.getName(), cf.getName()), CFMetaData.fromThrift(cf));
                }
                catch (InvalidRequestException e) {
                    throw new RuntimeException(e);
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    AbstractType getComparator(String keyspace, String columnFamily) {
        return this.metadata.get((Object)String.format((String)"%s.%s", (Object[])new Object[]{keyspace, columnFamily})).comparator;
    }

    AbstractType getNameType(String keyspace, String columnFamily, ByteBuffer name) {
        CFMetaData md = this.metadata.get(String.format("%s.%s", keyspace, columnFamily));
        try {
            if (ByteBufferUtil.string(name).equalsIgnoreCase(ByteBufferUtil.string(md.getKeyName()))) {
                return AsciiType.instance;
            }
        }
        catch (CharacterCodingException e) {
            // empty catch block
        }
        return md.comparator;
    }

    AbstractType getValueType(String keyspace, String columnFamily, ByteBuffer name) {
        CFMetaData md = this.metadata.get(String.format("%s.%s", keyspace, columnFamily));
        try {
            if (ByteBufferUtil.string(name).equalsIgnoreCase(ByteBufferUtil.string(md.getKeyName()))) {
                return md.getKeyValidator();
            }
        }
        catch (CharacterCodingException e) {
            // empty catch block
        }
        ColumnDefinition cd = md.getColumnDefinition(name);
        return cd == null ? md.getDefaultValidator() : cd.getValidator();
    }

    public AbstractType getKeyValidator(String keyspace, String columnFamily) {
        return this.metadata.get(String.format("%s.%s", keyspace, columnFamily)).getKeyValidator();
    }

    public String colNameAsString(String keyspace, String columnFamily, ByteBuffer name) {
        AbstractType comparator = this.getNameType(keyspace, columnFamily, name);
        return comparator.getString(name);
    }

    public TypedColumn makeCol(String keyspace, String columnFamily, Column column) {
        return new TypedColumn(column, this.getNameType(keyspace, columnFamily, column.name), this.getValueType(keyspace, columnFamily, column.name));
    }
}

