/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.cassandra.cql.jdbc.CassandraConnection;
import org.apache.cassandra.cql.jdbc.DriverResolverException;
import org.apache.cassandra.cql.jdbc.InvalidUrlException;

public class CassandraDriver
implements Driver {
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;
    private static String ACCEPTS_URL = "jdbc:cassandra";

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(ACCEPTS_URL);
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        if (this.acceptsURL(url)) {
            return new CassandraConnection(url);
        }
        throw new InvalidUrlException("Invalid connection url:" + url + ". should start with jdbc:cassandra");
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String arg0, Properties arg1) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            CassandraDriver driverInst = new CassandraDriver();
            DriverManager.registerDriver(driverInst);
        }
        catch (SQLException e) {
            throw new DriverResolverException(e.getMessage());
        }
    }
}

