/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.apache.cassandra.cql.jdbc.CassandraPreparedStatement;
import org.apache.cassandra.cql.jdbc.CassandraStatement;
import org.apache.cassandra.cql.jdbc.Connection;
import org.apache.cassandra.cql.jdbc.DriverResolverException;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;

class CassandraConnection
implements java.sql.Connection {
    private Connection cassandraCon;

    public CassandraConnection(String url) {
        try {
            int splitIndex = url.indexOf(64);
            String usr_pwd = url.substring(0, splitIndex);
            String host_port = url.substring(splitIndex + 1);
            int usr_colonIdx = usr_pwd.lastIndexOf(58);
            int usr_backwardIdx = usr_pwd.indexOf(47);
            String userName = usr_pwd.substring(usr_colonIdx + 1, usr_backwardIdx);
            String password = usr_pwd.substring(usr_backwardIdx + 1);
            int host_colonIdx = host_port.indexOf(58);
            String hostName = host_port.substring(0, host_colonIdx);
            int host_backwardIdx = host_port.indexOf(47);
            String port = host_port.substring(host_colonIdx + 1, host_backwardIdx);
            String keyspace = host_port.substring(host_backwardIdx + 1);
            this.cassandraCon = new Connection(hostName, Integer.valueOf(port), userName, password);
            String useQ = "USE " + keyspace;
            this.cassandraCon.execute(useQ);
        }
        catch (NumberFormatException e) {
            throw new DriverResolverException(e.getMessage());
        }
        catch (TTransportException e) {
            throw new DriverResolverException(e.getMessage());
        }
        catch (AuthenticationException e) {
            throw new DriverResolverException(e.getMessage());
        }
        catch (AuthorizationException e) {
            throw new DriverResolverException(e.getMessage());
        }
        catch (TException e) {
            throw new DriverResolverException(e.getMessage());
        }
        catch (InvalidRequestException e) {
            throw new DriverResolverException(e.getMessage());
        }
        catch (UnavailableException e) {
            throw new DriverResolverException(e.getMessage());
        }
        catch (TimedOutException e) {
            throw new DriverResolverException(e.getMessage());
        }
        catch (SchemaDisagreementException e) {
            throw new DriverResolverException("schema does not match across nodes, (try again later).");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void close() throws SQLException {
        if (this.cassandraCon != null) {
            this.cassandraCon.close();
        }
    }

    @Override
    public void commit() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new CassandraStatement(this.cassandraCon);
    }

    @Override
    public Statement createStatement(int arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public String getCatalog() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public String nativeSQL(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public CallableStatement prepareCall(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new CassandraPreparedStatement(this.cassandraCon, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void rollback() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void rollback(Savepoint arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setAutoCommit(boolean arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setTransactionIsolation(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }
}

