/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql.jdbc.AbstractResultSet;
import org.apache.cassandra.cql.jdbc.CassandraResultSet;
import org.apache.cassandra.cql.jdbc.ColumnDecoder;
import org.apache.cassandra.cql.jdbc.TypedColumn;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CResultSet
extends AbstractResultSet
implements CassandraResultSet {
    private final ColumnDecoder decoder;
    private final String keyspace;
    private final String columnFamily;
    private Iterator<CqlRow> rSetIter;
    int rowNumber = 0;
    private byte[] curRowKey = null;
    private List<TypedColumn> values = new ArrayList<TypedColumn>();
    private Map<String, TypedColumn> valueMap = new HashMap<String, TypedColumn>();
    private final CResultSetMetaData meta;
    private boolean wasNull;

    CResultSet(CqlResult resultSet, ColumnDecoder decoder, String keyspace, String columnFamily) {
        this.decoder = decoder;
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.rSetIter = resultSet.getRowsIterator();
        this.meta = new CResultSetMetaData();
    }

    @Override
    public byte[] getKey() {
        return this.curRowKey;
    }

    @Override
    public TypedColumn getColumn(int i) {
        return this.values.get(i);
    }

    @Override
    public TypedColumn getColumn(String name) {
        return this.valueMap.get(name);
    }

    @Override
    public void close() throws SQLException {
        this.valueMap = null;
        this.values = null;
    }

    private byte[] getBytes(TypedColumn column) {
        ByteBuffer value = (ByteBuffer)column.getValue();
        this.wasNull = value == null;
        return value == null ? null : ByteBufferUtil.clone(value).array();
    }

    @Override
    public byte[] getBytes(int index) throws SQLException {
        return this.getBytes(this.values.get(index - 1));
    }

    @Override
    public byte[] getBytes(String name) throws SQLException {
        return this.getBytes(this.valueMap.get(name));
    }

    @Override
    public Date getDate(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Date getDate(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public double getDouble(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public double getDouble(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public float getFloat(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public float getFloat(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean getBoolean(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean getBoolean(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    private BigInteger getBigInteger(TypedColumn column) {
        BigInteger value = (BigInteger)column.getValue();
        this.wasNull = value == null;
        return value;
    }

    @Override
    public BigInteger getBigInteger(int i) {
        return this.getBigInteger(this.values.get(i - 1));
    }

    @Override
    public BigInteger getBigInteger(String name) {
        return this.getBigInteger(this.valueMap.get(name));
    }

    private int getInt(TypedColumn column) throws SQLException {
        if (column.getValue() instanceof BigInteger) {
            this.wasNull = false;
            return this.getBigInteger(column).intValue();
        }
        if (column.getValue() instanceof Long) {
            this.wasNull = false;
            return this.getLong(column).intValue();
        }
        if (column.getValue() == null) {
            this.wasNull = true;
            return 0;
        }
        throw new SQLException("Non-integer value " + column.getValue());
    }

    @Override
    public int getInt(int index) throws SQLException {
        return this.getInt(this.values.get(index - 1));
    }

    @Override
    public int getInt(String name) throws SQLException {
        return this.getInt(this.valueMap.get(name));
    }

    private Long getLong(TypedColumn column) {
        Long value = (Long)column.getValue();
        this.wasNull = value == null;
        return value == null ? 0L : value;
    }

    @Override
    public long getLong(int index) throws SQLException {
        return this.getLong(this.values.get(index - 1));
    }

    @Override
    public long getLong(String name) throws SQLException {
        return this.getLong(this.valueMap.get(name));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.meta;
    }

    private Object getObject(TypedColumn column) {
        Object value = column.getValue();
        this.wasNull = value == null;
        return value;
    }

    @Override
    public Object getObject(int index) throws SQLException {
        return this.getObject(this.values.get(index - 1));
    }

    @Override
    public Object getObject(String name) throws SQLException {
        return this.getObject(this.valueMap.get(name));
    }

    @Override
    public Object getObject(int arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Object getObject(String arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowNumber;
    }

    private String getString(TypedColumn column) {
        String value = (String)column.getValue();
        this.wasNull = value == null;
        return value == null ? null : value;
    }

    @Override
    public String getString(int index) throws SQLException {
        return this.getString(this.values.get(index - 1));
    }

    @Override
    public String getString(String name) throws SQLException {
        return this.getString(this.valueMap.get(name));
    }

    @Override
    public Time getTime(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Time getTime(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Timestamp getTimestamp(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Timestamp getTimestamp(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.rowNumber == Integer.MAX_VALUE;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.rowNumber == 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.valueMap == null;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.rowNumber == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return !this.rSetIter.hasNext();
    }

    @Override
    public boolean last() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.equals(CassandraResultSet.class)) {
            return (T)this;
        }
        throw new SQLException("Unsupported unwrap interface: " + iface.getSimpleName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return CassandraResultSet.class.isAssignableFrom(iface);
    }

    @Override
    public synchronized boolean next() throws SQLException {
        if (!this.values.isEmpty() || !this.valueMap.isEmpty()) {
            this.values.clear();
            this.valueMap.clear();
        }
        if (this.rSetIter != null && this.rSetIter.hasNext()) {
            CqlRow row = this.rSetIter.next();
            ++this.rowNumber;
            this.curRowKey = row.getKey();
            List cols = row.getColumns();
            for (Column col : cols) {
                TypedColumn c = this.decoder.makeCol(this.keyspace, this.columnFamily, col);
                this.values.add(c);
                this.valueMap.put(this.decoder.colNameAsString(this.keyspace, this.columnFamily, col.name), c);
            }
            return !this.values.isEmpty() || !this.valueMap.isEmpty();
        }
        this.rowNumber = Integer.MAX_VALUE;
        return false;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    class CResultSetMetaData
    implements ResultSetMetaData {
        CResultSetMetaData() {
        }

        private void checkIndex(int i) throws SQLException {
            if (i >= CResultSet.this.values.size()) {
                throw new SQLException("Invalid column index " + i);
            }
        }

        @Override
        public int getColumnCount() throws SQLException {
            return CResultSet.this.values.size();
        }

        @Override
        public boolean isAutoIncrement(int column) throws SQLException {
            this.checkIndex(--column);
            return ((TypedColumn)CResultSet.this.values.get(column)).getValueType() instanceof CounterColumnType;
        }

        @Override
        public boolean isCaseSensitive(int column) throws SQLException {
            this.checkIndex(--column);
            TypedColumn tc = (TypedColumn)CResultSet.this.values.get(column);
            return tc.getValueType().isCaseSensitive();
        }

        @Override
        public boolean isSearchable(int column) throws SQLException {
            return false;
        }

        @Override
        public boolean isCurrency(int column) throws SQLException {
            this.checkIndex(--column);
            TypedColumn tc = (TypedColumn)CResultSet.this.values.get(column);
            return tc.getValueType().isCurrency();
        }

        @Override
        public int isNullable(int column) throws SQLException {
            return 1;
        }

        @Override
        public boolean isSigned(int column) throws SQLException {
            this.checkIndex(--column);
            TypedColumn tc = (TypedColumn)CResultSet.this.values.get(column);
            return tc.getValueType().isSigned();
        }

        @Override
        public int getColumnDisplaySize(int column) throws SQLException {
            this.checkIndex(--column);
            return ((TypedColumn)CResultSet.this.values.get(column)).getValueString().length();
        }

        @Override
        public String getColumnLabel(int column) throws SQLException {
            return this.getColumnName(column);
        }

        @Override
        public String getColumnName(int column) throws SQLException {
            this.checkIndex(--column);
            return ((TypedColumn)CResultSet.this.values.get(column)).getNameString();
        }

        @Override
        public String getSchemaName(int column) throws SQLException {
            return CResultSet.this.keyspace;
        }

        @Override
        public int getPrecision(int column) throws SQLException {
            this.checkIndex(--column);
            TypedColumn col = (TypedColumn)CResultSet.this.values.get(column);
            return col.getValueType().getPrecision(col.getValue());
        }

        @Override
        public int getScale(int column) throws SQLException {
            this.checkIndex(--column);
            TypedColumn tc = (TypedColumn)CResultSet.this.values.get(column);
            return tc.getValueType().getScale(tc.getValue());
        }

        @Override
        public String getTableName(int column) throws SQLException {
            return CResultSet.this.columnFamily;
        }

        @Override
        public String getCatalogName(int column) throws SQLException {
            throw new SQLFeatureNotSupportedException("Cassandra has no catalogs");
        }

        @Override
        public int getColumnType(int column) throws SQLException {
            this.checkIndex(--column);
            return ((TypedColumn)CResultSet.this.values.get(column)).getValueType().getJdbcType();
        }

        @Override
        public String getColumnTypeName(int column) throws SQLException {
            this.checkIndex(--column);
            return ((TypedColumn)CResultSet.this.values.get(column)).getValueType().getClass().getSimpleName();
        }

        @Override
        public boolean isReadOnly(int column) throws SQLException {
            return column == 0;
        }

        @Override
        public boolean isWritable(int column) throws SQLException {
            return column > 0;
        }

        @Override
        public boolean isDefinitelyWritable(int column) throws SQLException {
            return this.isWritable(column);
        }

        @Override
        public String getColumnClassName(int column) throws SQLException {
            this.checkIndex(--column);
            return ((TypedColumn)CResultSet.this.values.get(column)).getValueType().getType().getName();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLException("No wrapping implemented");
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }
    }
}

