/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.sstable.KeyIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ReducingIterator;
import org.apache.commons.collections.iterators.CollatingIterator;

public class ReducingKeyIterator
implements Iterator<DecoratedKey>,
Closeable {
    private final CollatingIterator ci = FBUtilities.getCollatingIterator();
    private final ReducingIterator<DecoratedKey, DecoratedKey> iter;

    public ReducingKeyIterator(Collection<SSTableReader> sstables) {
        for (SSTableReader sstable : sstables) {
            this.ci.addIterator((Iterator)new KeyIterator(sstable.descriptor));
        }
        this.iter = new ReducingIterator<DecoratedKey, DecoratedKey>((Iterator)this.ci){
            DecoratedKey reduced;
            {
                this.reduced = null;
            }

            @Override
            public void reduce(DecoratedKey current) {
                this.reduced = current;
            }

            @Override
            protected DecoratedKey getReduced() {
                return this.reduced;
            }
        };
    }

    @Override
    public void close() throws IOException {
        for (Object o : this.ci.getIterators()) {
            ((KeyIterator)o).close();
        }
    }

    public long getTotalBytes() {
        long m = 0L;
        for (Object o : this.ci.getIterators()) {
            m += ((KeyIterator)o).getTotalBytes();
        }
        return m;
    }

    public long getBytesRead() {
        long m = 0L;
        for (Object o : this.ci.getIterators()) {
            m += ((KeyIterator)o).getBytesRead();
        }
        return m;
    }

    public String getTaskType() {
        return "Secondary index build";
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public DecoratedKey next() {
        return (DecoratedKey)this.iter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

