/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowMutationVerbHandler
implements IVerbHandler {
    private static Logger logger_ = LoggerFactory.getLogger(RowMutationVerbHandler.class);

    @Override
    public void doVerb(Message message, String id) {
        try {
            byte[] forwardBytes;
            byte[] hintedBytes;
            RowMutation rm = RowMutation.fromBytes(message.getMessageBody(), message.getVersion());
            if (logger_.isDebugEnabled()) {
                logger_.debug("Applying " + rm);
            }
            if ((hintedBytes = message.getHeader("HINT")) != null) {
                assert (hintedBytes.length > 0);
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(hintedBytes));
                while (dis.available() > 0) {
                    ByteBuffer addressBytes = ByteBufferUtil.readWithShortLength(dis);
                    if (logger_.isDebugEnabled()) {
                        logger_.debug("Adding hint for " + InetAddress.getByName(ByteBufferUtil.string(addressBytes)));
                    }
                    RowMutation hintedMutation = new RowMutation("system", addressBytes);
                    hintedMutation.addHints(rm);
                    hintedMutation.apply();
                }
            }
            if ((forwardBytes = message.getHeader("FORWARD")) != null) {
                this.forwardToLocalNodes(message, forwardBytes);
            }
            Table.open(rm.getTable()).apply(rm, true);
            WriteResponse response = new WriteResponse(rm.getTable(), rm.key(), true);
            Message responseMessage = WriteResponse.makeWriteResponseMessage(message, response);
            if (logger_.isDebugEnabled()) {
                logger_.debug(rm + " applied.  Sending response to " + id + "@" + message.getFrom());
            }
            MessagingService.instance().sendReply(responseMessage, id, message.getFrom());
        }
        catch (IOException e) {
            logger_.error("Error in row mutation", (Throwable)e);
        }
    }

    private void forwardToLocalNodes(Message message, byte[] forwardBytes) throws UnknownHostException {
        message.removeHeader("FORWARD");
        int bytesPerInetAddress = FBUtilities.getLocalAddress().getAddress().length;
        assert (forwardBytes.length >= bytesPerInetAddress);
        assert (forwardBytes.length % bytesPerInetAddress == 0);
        byte[] addressBytes = new byte[bytesPerInetAddress];
        for (int offset = 0; offset < forwardBytes.length; offset += bytesPerInetAddress) {
            System.arraycopy(forwardBytes, offset, addressBytes, 0, bytesPerInetAddress);
            InetAddress address = InetAddress.getByAddress(addressBytes);
            if (logger_.isDebugEnabled()) {
                logger_.debug("Forwarding message to " + address);
            }
            MessagingService.instance().sendOneWay(message, address);
        }
    }
}

