/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.UUID;
import java.util.zip.Deflater;
import org.apache.cassandra.cql.jdbc.ColumnMetaData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.thrift.Compression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    Utils() {
    }

    public static ByteBuffer compressQuery(String queryStr, Compression compression) {
        byte[] data = queryStr.getBytes(Charsets.UTF_8);
        Deflater compressor = new Deflater();
        compressor.setInput(data);
        compressor.finish();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (!compressor.finished()) {
            int size = compressor.deflate(buffer);
            byteArray.write(buffer, 0, size);
        }
        logger.trace("Compressed query statement {} bytes in length to {} bytes", (Object)data.length, (Object)byteArray.size());
        return ByteBuffer.wrap(byteArray.toByteArray());
    }

    static int getJdbcType(AbstractType type) throws SQLException {
        if (type instanceof ColumnMetaData) {
            return ((ColumnMetaData)((Object)type)).getType();
        }
        if (type == IntegerType.instance) {
            return -5;
        }
        if (type.getType().equals(Long.class)) {
            return -5;
        }
        if (type.getType().equals(String.class)) {
            return 12;
        }
        if (type.getType().equals(UUID.class)) {
            return 93;
        }
        if (type == BytesType.instance) {
            return -2;
        }
        throw new SQLException("Uninterpretable JDBC type " + type.getClass().getName());
    }

    static boolean isTypeSigned(AbstractType type) {
        if (type == IntegerType.instance || type == LongType.instance) {
            return true;
        }
        if (type instanceof ColumnMetaData) {
            return ((ColumnMetaData)((Object)type)).isSigned();
        }
        return false;
    }

    static int getTypeScale(AbstractType type) {
        if (type instanceof ColumnMetaData) {
            return ((ColumnMetaData)((Object)type)).getScale();
        }
        return 0;
    }
}

