/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql.jdbc.TypedColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ColumnDecoder {
    private static final Logger logger = LoggerFactory.getLogger(ColumnDecoder.class);
    private static final String MapFormatString = "%s.%s.%s.%s";
    private Map<String, CfDef> cfDefs = new HashMap<String, CfDef>();
    private Map<String, AbstractType> comparators = new HashMap<String, AbstractType>();

    public ColumnDecoder(List<KsDef> defs) {
        for (KsDef ks : defs) {
            for (CfDef cf : ks.getCf_defs()) {
                this.cfDefs.put(String.format("%s.%s", ks.getName(), cf.getName()), cf);
                for (ColumnDef cd : cf.getColumn_metadata()) {
                    try {
                        this.comparators.put(String.format(MapFormatString, ks.getName(), cf.getName(), Specifier.ColumnSpecific.name(), ByteBufferUtil.bytesToHex(cd.bufferForName())), FBUtilities.getComparator(cd.getValidation_class()));
                    }
                    catch (ConfigurationException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
    }

    AbstractType getComparator(String keyspace, String columnFamily, Specifier specifier, CfDef def) {
        return this.getComparator(keyspace, columnFamily, null, specifier, def);
    }

    AbstractType getComparator(String keyspace, String columnFamily, byte[] column, Specifier specifier, CfDef def) {
        String key = String.format(MapFormatString, keyspace, columnFamily, specifier.name(), FBUtilities.bytesToHex(column == null ? new byte[]{} : column));
        AbstractType comparator = this.comparators.get(key);
        if (comparator == null) {
            if (def == null) {
                def = this.cfDefs.get(String.format("%s.%s", keyspace, columnFamily));
            }
            if (def == null) {
                return null;
            }
            try {
                switch (specifier) {
                    case Key: {
                        comparator = FBUtilities.getComparator(def.getKey_validation_class());
                        break;
                    }
                    case ColumnSpecific: 
                    case Validator: {
                        comparator = FBUtilities.getComparator(def.getDefault_validation_class());
                        break;
                    }
                    default: {
                        comparator = FBUtilities.getComparator(def.getComparator_type());
                    }
                }
                this.comparators.put(key, comparator);
            }
            catch (ConfigurationException ex) {
                throw new RuntimeException(ex);
            }
        }
        return comparator;
    }

    public String colNameAsString(String keyspace, String columnFamily, String name) {
        AbstractType comparator = this.getComparator(keyspace, columnFamily, Specifier.Comparator, null);
        ByteBuffer bb = comparator.fromString(name);
        return comparator.getString(bb);
    }

    public String colNameAsString(String keyspace, String columnFamily, byte[] name) {
        AbstractType comparator = this.getComparator(keyspace, columnFamily, Specifier.Comparator, null);
        return comparator.getString(ByteBuffer.wrap(name));
    }

    public static String colValueAsString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof byte[]) {
            return ByteBufferUtil.bytesToHex(ByteBuffer.wrap((byte[])value));
        }
        return value == null ? null : value.toString();
    }

    public TypedColumn makeCol(String keyspace, String columnFamily, byte[] name, byte[] value) {
        CfDef cfDef = this.cfDefs.get(String.format("%s.%s", keyspace, columnFamily));
        AbstractType comparator = this.getComparator(keyspace, columnFamily, Specifier.Comparator, cfDef);
        AbstractType validator = this.getComparator(keyspace, columnFamily, name, Specifier.ColumnSpecific, null);
        return new TypedColumn(comparator, name, validator, value);
    }

    static enum Specifier {
        Comparator,
        Validator,
        Key,
        ColumnSpecific;

    }
}

