/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EndpointStatesSerializationHelper {
    private static final Logger logger_ = LoggerFactory.getLogger(EndpointStatesSerializationHelper.class);

    EndpointStatesSerializationHelper() {
    }

    static void serialize(Map<InetAddress, EndpointState> epStateMap, DataOutputStream dos) throws IOException {
        dos.writeInt(epStateMap.size());
        for (Map.Entry<InetAddress, EndpointState> entry : epStateMap.entrySet()) {
            InetAddress ep = entry.getKey();
            CompactEndpointSerializationHelper.serialize(ep, dos);
            EndpointState.serializer().serialize(entry.getValue(), dos);
        }
    }

    static Map<InetAddress, EndpointState> deserialize(DataInputStream dis) throws IOException {
        int size = dis.readInt();
        HashMap<InetAddress, EndpointState> epStateMap = new HashMap<InetAddress, EndpointState>(size);
        for (int i = 0; i < size; ++i) {
            assert (dis.available() > 0);
            InetAddress ep = CompactEndpointSerializationHelper.deserialize(dis);
            EndpointState epState = EndpointState.serializer().deserialize(dis);
            epStateMap.put(ep, epState);
        }
        return epStateMap;
    }
}

