/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.cassandra.avro.KsDef;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.io.SerDeUtils;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;

public class DefsTable {
    public static final ByteBuffer DEFINITION_SCHEMA_COLUMN_NAME = ByteBufferUtil.bytes("Avro/Schema");

    public static synchronized void dumpToStorage(UUID version) throws IOException {
        ByteBuffer versionKey = Migration.toUTF8Bytes(version);
        List<String> ksnames = DatabaseDescriptor.getNonSystemTables();
        RowMutation rm = new RowMutation("system", versionKey);
        long now = System.currentTimeMillis();
        for (String ksname : ksnames) {
            KSMetaData ksm = DatabaseDescriptor.getTableDefinition(ksname);
            rm.add(new QueryPath("Schema", null, ByteBufferUtil.bytes(ksm.name)), SerDeUtils.serialize(ksm.deflate()), now);
        }
        rm.add(new QueryPath("Schema", null, DEFINITION_SCHEMA_COLUMN_NAME), ByteBufferUtil.bytes(KsDef.SCHEMA$.toString()), now);
        rm.apply();
        rm = new RowMutation("system", Migration.LAST_MIGRATION_KEY);
        rm.add(new QueryPath("Schema", null, Migration.LAST_MIGRATION_KEY), ByteBuffer.wrap(UUIDGen.decompose(version)), now);
        rm.apply();
    }

    public static synchronized Collection<KSMetaData> loadFromStorage(UUID version) throws IOException {
        QueryFilter filter;
        DecoratedKey vkey = StorageService.getPartitioner().decorateKey(Migration.toUTF8Bytes(version));
        Table defs = Table.open("system");
        ColumnFamilyStore cfStore = defs.getColumnFamilyStore("Schema");
        ColumnFamily cf = cfStore.getColumnFamily(filter = QueryFilter.getIdentityFilter(vkey, new QueryPath("Schema")));
        IColumn avroschema = cf.getColumn(DEFINITION_SCHEMA_COLUMN_NAME);
        if (avroschema == null) {
            throw new RuntimeException("Cannot read system table! Are you upgrading a pre-release version?");
        }
        ByteBuffer value = avroschema.value();
        Schema schema = Schema.parse((String)ByteBufferUtil.string(value));
        ArrayList<KSMetaData> keyspaces = new ArrayList<KSMetaData>();
        for (IColumn column : cf.getSortedColumns()) {
            if (column.name().equals(DEFINITION_SCHEMA_COLUMN_NAME)) continue;
            KsDef ks = SerDeUtils.deserialize(schema, column.value(), new KsDef());
            keyspaces.add(KSMetaData.inflate(ks));
        }
        return keyspaces;
    }

    public static Set<File> getFiles(String table, final String cf) {
        HashSet<File> found = new HashSet<File>();
        for (String path : DatabaseDescriptor.getAllDataFileLocationsForTable(table)) {
            File[] dbFiles = new File(path).listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith(cf + "-") && pathname.getName().endsWith(".db") && pathname.exists();
                }
            });
            found.addAll(Arrays.asList(dbFiles));
        }
        return found;
    }
}

