/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.avro;

import javax.servlet.Servlet;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.ResponderServlet;
import org.apache.avro.specific.SpecificResponder;
import org.apache.cassandra.avro.Cassandra;
import org.apache.cassandra.avro.CassandraServer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.service.AbstractCassandraDaemon;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemon
extends AbstractCassandraDaemon {
    private static Logger logger = LoggerFactory.getLogger(CassandraDaemon.class);
    private Server server;

    @Override
    protected void startServer() {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Binding avro service to %s:%s", this.listenAddr, this.listenPort));
        }
        CassandraServer cassandraServer = new CassandraServer();
        SpecificResponder responder = new SpecificResponder(Cassandra.class, (Object)cassandraServer);
        logger.info("Listening for avro clients...");
        this.server = new Server(this.listenPort);
        this.server.setThreadPool((ThreadPool)new AbstractCassandraDaemon.CleaningThreadPool(cassandraServer.clientState, DatabaseDescriptor.getRpcMinThreads(), DatabaseDescriptor.getRpcMaxThreads()));
        try {
            ResponderServlet servlet = new ResponderServlet((Responder)responder);
            new Context((HandlerContainer)this.server, "/").addServlet(new ServletHolder((Servlet)servlet), "/*");
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start Avro server.", e);
        }
    }

    @Override
    protected void stopServer() {
        try {
            logger.info("Stop listening for avro clients");
            this.server.stop();
        }
        catch (Exception e) {
            logger.error("Avro server did not exit cleanly.", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        new CassandraDaemon().activate();
    }
}

