/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.streaming;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.cassandra.avro.Mutation;
import org.apache.cassandra.avro.StreamingMutation;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.hadoop.streaming.PipeMapRed;
import org.apache.hadoop.streaming.io.OutputReader;

public class AvroOutputReader
extends OutputReader<ByteBuffer, List<Mutation>> {
    private BinaryDecoder decoder;
    private SpecificDatumReader<StreamingMutation> reader;
    private final StreamingMutation entry = new StreamingMutation();
    private final ArrayList<Mutation> mutations = new ArrayList(1);

    public void initialize(PipeMapRed pmr) throws IOException {
        super.initialize(pmr);
        InputStream in = pmr.getClientInput() instanceof InputStream ? (InputStream)((Object)pmr.getClientInput()) : new FromDataInputStream(pmr.getClientInput());
        this.decoder = DecoderFactory.defaultFactory().createBinaryDecoder(in, null);
        this.reader = new SpecificDatumReader(StreamingMutation.SCHEMA$);
    }

    public boolean readKeyValue() throws IOException {
        try {
            this.reader.read((Object)this.entry, (Decoder)this.decoder);
        }
        catch (EOFException e) {
            return false;
        }
        this.mutations.clear();
        this.mutations.add(this.entry.mutation);
        return true;
    }

    public ByteBuffer getCurrentKey() throws IOException {
        return this.entry.key;
    }

    public List<Mutation> getCurrentValue() throws IOException {
        return this.mutations;
    }

    public String getLastOutput() {
        return this.entry.toString();
    }

    private static final class FromDataInputStream
    extends InputStream {
        private final DataInput in;

        public FromDataInputStream(DataInput in) {
            this.in = in;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            try {
                return this.in.readUnsignedByte();
            }
            catch (EOFException e) {
                return -1;
            }
        }

        @Override
        public long skip(long n) throws IOException {
            FileUtils.skipBytesFully(this.in, n);
            return n;
        }
    }
}

