/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletedColumn
extends Column {
    private static Logger logger = LoggerFactory.getLogger(DeletedColumn.class);

    public DeletedColumn(ByteBuffer name, int localDeletionTime, long timestamp) {
        this(name, ByteBufferUtil.bytes(localDeletionTime), timestamp);
    }

    public DeletedColumn(ByteBuffer name, ByteBuffer value, long timestamp) {
        super(name, value, timestamp);
    }

    @Override
    public boolean isMarkedForDelete() {
        return true;
    }

    @Override
    public long getMarkedForDeleteAt() {
        return this.timestamp;
    }

    @Override
    public int getLocalDeletionTime() {
        return this.value.getInt(this.value.position());
    }

    @Override
    public IColumn deepCopy() {
        return new DeletedColumn(ByteBufferUtil.clone(this.name), ByteBufferUtil.clone(this.value), this.timestamp);
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        if (this.value().remaining() != 4) {
            throw new MarshalException("A tombstone value should be 4 bytes long");
        }
        if (this.getLocalDeletionTime() < 0) {
            throw new MarshalException("The local deletion time should not be negative");
        }
    }
}

