/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Function;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.cassandra.utils.Pair;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiringMap<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(ExpiringMap.class);
    private final Function<Pair<K, V>, ?> postExpireHook;
    private final NonBlockingHashMap<K, CacheableObject<V>> cache = new NonBlockingHashMap();
    private final Timer timer;
    private static int counter = 0;

    public ExpiringMap(long expiration) {
        this(expiration, null);
    }

    public ExpiringMap(long expiration, Function<Pair<K, V>, ?> postExpireHook) {
        this.postExpireHook = postExpireHook;
        if (expiration <= 0L) {
            throw new IllegalArgumentException("Argument specified must be a positive number");
        }
        this.timer = new Timer("EXPIRING-MAP-TIMER-" + ++counter, true);
        this.timer.schedule((TimerTask)new CacheMonitor(expiration), expiration / 2L, expiration / 2L);
    }

    public void shutdown() {
        this.timer.cancel();
    }

    public V put(K key, V value) {
        CacheableObject previous = (CacheableObject)this.cache.put(key, new CacheableObject<V>(value));
        return previous == null ? null : (V)previous.getValue();
    }

    public V get(K key) {
        CacheableObject co = (CacheableObject)this.cache.get(key);
        return co == null ? null : (V)co.getValue();
    }

    public V remove(K key) {
        CacheableObject co = (CacheableObject)this.cache.remove(key);
        return co == null ? null : (V)co.getValue();
    }

    public long getAge(K key) {
        CacheableObject co = (CacheableObject)this.cache.get(key);
        return co == null ? 0L : co.age;
    }

    public int size() {
        return this.cache.size();
    }

    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public Set<K> keySet() {
        return this.cache.keySet();
    }

    private class CacheMonitor
    extends TimerTask {
        private final long expiration;

        CacheMonitor(long expiration) {
            this.expiration = expiration;
        }

        @Override
        public void run() {
            for (Map.Entry entry : ExpiringMap.this.cache.entrySet()) {
                if (!((CacheableObject)entry.getValue()).isReadyToDie(this.expiration)) continue;
                ExpiringMap.this.cache.remove(entry.getKey());
                if (ExpiringMap.this.postExpireHook == null) continue;
                ExpiringMap.this.postExpireHook.apply(new Pair(entry.getKey(), ((CacheableObject)entry.getValue()).getValue()));
            }
        }
    }

    private static class CacheableObject<T> {
        private final T value;
        private final long age;

        CacheableObject(T o) {
            assert (o != null);
            this.value = o;
            this.age = System.currentTimeMillis();
        }

        T getValue() {
            return this.value;
        }

        boolean isReadyToDie(long expiration) {
            return System.currentTimeMillis() - this.age > expiration;
        }
    }
}

