/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.RowRepairResolver;
import org.apache.cassandra.utils.WrappedRunnable;

public class AsyncRepairCallback
implements IAsyncCallback {
    private final RowRepairResolver repairResolver;
    private final int count;

    public AsyncRepairCallback(RowRepairResolver repairResolver, int count) {
        this.repairResolver = repairResolver;
        this.count = count;
    }

    @Override
    public void response(Message message) {
        this.repairResolver.preprocess(message);
        if (this.repairResolver.getMessageCount() == this.count) {
            StageManager.getStage(Stage.READ_REPAIR).execute(new WrappedRunnable(){

                @Override
                protected void runMayThrow() throws DigestMismatchException, IOException {
                    AsyncRepairCallback.this.repairResolver.resolve();
                }
            });
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return true;
    }
}

