/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import com.google.common.base.Charsets;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.avro.KsDef;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CompactionManager;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DefsTable;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.SerDeUtils;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.avro.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Migration {
    protected static final Logger logger = LoggerFactory.getLogger(Migration.class);
    public static final String NAME_VALIDATOR_REGEX = "\\w+";
    public static final String MIGRATIONS_CF = "Migrations";
    public static final String SCHEMA_CF = "Schema";
    public static final ByteBuffer MIGRATIONS_KEY = ByteBufferUtil.bytes("Migrations Key");
    public static final ByteBuffer LAST_MIGRATION_KEY = ByteBufferUtil.bytes("Last Migration");
    protected RowMutation rm;
    protected java.util.UUID newVersion;
    protected java.util.UUID lastVersion;
    protected transient boolean clientMode = StorageService.instance.isClientMode();

    protected Migration() {
    }

    Migration(java.util.UUID newVersion, java.util.UUID lastVersion) {
        this();
        this.newVersion = newVersion;
        this.lastVersion = lastVersion;
    }

    protected final void acquireLocks() {
        CompactionManager.instance.getCompactionLock().lock();
        Table.getFlushLock().lock();
    }

    protected final void releaseLocks() {
        Table.getFlushLock().unlock();
        CompactionManager.instance.getCompactionLock().unlock();
    }

    public void beforeApplyModels() {
    }

    public final void apply() throws IOException, ConfigurationException {
        if (!DatabaseDescriptor.getDefsVersion().equals(this.lastVersion)) {
            throw new ConfigurationException("Previous version mismatch. cannot apply.");
        }
        assert (this.rm != null);
        if (!this.clientMode) {
            this.rm.apply();
        }
        this.beforeApplyModels();
        if (!this.clientMode) {
            long now = System.currentTimeMillis();
            ByteBuffer buf = this.serialize();
            RowMutation migration = new RowMutation("system", MIGRATIONS_KEY);
            migration.add(new QueryPath(MIGRATIONS_CF, null, ByteBuffer.wrap(UUIDGen.decompose(this.newVersion))), buf, now);
            migration.apply();
            logger.info("Applying migration {} {}", (Object)this.newVersion.toString(), (Object)this.toString());
            migration = new RowMutation("system", LAST_MIGRATION_KEY);
            migration.add(new QueryPath(SCHEMA_CF, null, LAST_MIGRATION_KEY), ByteBuffer.wrap(UUIDGen.decompose(this.newVersion)), now);
            migration.apply();
            ColumnFamilyStore[] schemaStores = new ColumnFamilyStore[]{Table.open("system").getColumnFamilyStore(MIGRATIONS_CF), Table.open("system").getColumnFamilyStore(SCHEMA_CF)};
            ArrayList<Object> flushes = new ArrayList<Object>();
            for (ColumnFamilyStore cfs : schemaStores) {
                flushes.add(cfs.forceFlush());
            }
            for (Future future : flushes) {
                if (future == null) continue;
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new IOException(e);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        }
        this.applyModels();
    }

    public final void announce() {
        if (StorageService.instance.isClientMode()) {
            return;
        }
        MigrationManager.announce(this.newVersion, Gossiper.instance.getLiveMembers());
    }

    public final void passiveAnnounce() {
        MigrationManager.passiveAnnounce(this.newVersion);
    }

    public static java.util.UUID getLastMigrationId() {
        QueryFilter filter;
        DecoratedKey dkey = StorageService.getPartitioner().decorateKey(LAST_MIGRATION_KEY);
        Table defs = Table.open("system");
        ColumnFamilyStore cfStore = defs.getColumnFamilyStore(SCHEMA_CF);
        ColumnFamily cf = cfStore.getColumnFamily(filter = QueryFilter.getNamesFilter(dkey, new QueryPath(SCHEMA_CF), LAST_MIGRATION_KEY));
        if (cf == null || cf.getColumnNames().size() == 0) {
            return null;
        }
        return UUIDGen.getUUID(cf.getColumn(LAST_MIGRATION_KEY).value());
    }

    abstract void applyModels() throws IOException;

    public abstract void subdeflate(org.apache.cassandra.db.migration.avro.Migration var1);

    public abstract void subinflate(org.apache.cassandra.db.migration.avro.Migration var1);

    public java.util.UUID getVersion() {
        return this.newVersion;
    }

    static RowMutation makeDefinitionMutation(KSMetaData add, KSMetaData remove2, java.util.UUID versionId) throws IOException {
        ArrayList<KSMetaData> ksms = new ArrayList<KSMetaData>();
        for (String tableName : DatabaseDescriptor.getNonSystemTables()) {
            if (remove2 != null && remove2.name.equals(tableName) || add != null && add.name.equals(tableName)) continue;
            ksms.add(DatabaseDescriptor.getTableDefinition(tableName));
        }
        if (add != null) {
            ksms.add(add);
        }
        RowMutation rm = new RowMutation("system", Migration.toUTF8Bytes(versionId));
        long now = System.currentTimeMillis();
        for (KSMetaData ksm : ksms) {
            rm.add(new QueryPath(SCHEMA_CF, null, ByteBuffer.wrap(ksm.name.getBytes(Charsets.UTF_8))), SerDeUtils.serialize(ksm.deflate()), now);
        }
        rm.add(new QueryPath(SCHEMA_CF, null, DefsTable.DEFINITION_SCHEMA_COLUMN_NAME), ByteBuffer.wrap(KsDef.SCHEMA$.toString().getBytes(Charsets.UTF_8)), now);
        return rm;
    }

    public ByteBuffer serialize() throws IOException {
        org.apache.cassandra.db.migration.avro.Migration mi = new org.apache.cassandra.db.migration.avro.Migration();
        mi.old_version = new UUID();
        mi.old_version.bytes(UUIDGen.decompose(this.lastVersion));
        mi.new_version = new UUID();
        mi.new_version.bytes(UUIDGen.decompose(this.newVersion));
        mi.classname = new Utf8(this.getClass().getName());
        DataOutputBuffer dob = new DataOutputBuffer();
        try {
            RowMutation.serializer().serialize(this.rm, (DataOutputStream)dob);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        mi.row_mutation = ByteBuffer.wrap(dob.asByteArray());
        this.subdeflate(mi);
        return SerDeUtils.serializeWithSchema(mi);
    }

    public static Migration deserialize(ByteBuffer bytes) throws IOException {
        Migration migration;
        org.apache.cassandra.db.migration.avro.Migration mi = SerDeUtils.deserializeWithSchema(bytes, new org.apache.cassandra.db.migration.avro.Migration());
        try {
            Class<?> migrationClass = Class.forName(((Object)mi.classname).toString());
            Constructor<?> migrationConstructor = migrationClass.getDeclaredConstructor(new Class[0]);
            migrationConstructor.setAccessible(true);
            migration = (Migration)migrationConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid migration class: " + ((Object)mi.classname).toString(), e);
        }
        migration.lastVersion = UUIDGen.getUUID(ByteBuffer.wrap(mi.old_version.bytes()));
        migration.newVersion = UUIDGen.getUUID(ByteBuffer.wrap(mi.new_version.bytes()));
        try {
            migration.rm = RowMutation.serializer().deserialize(SerDeUtils.createDataInputStream(mi.row_mutation));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        migration.subinflate(mi);
        return migration;
    }

    public static Collection<IColumn> getLocalMigrations(java.util.UUID start, java.util.UUID end) {
        DecoratedKey dkey = StorageService.getPartitioner().decorateKey(MIGRATIONS_KEY);
        Table defs = Table.open("system");
        ColumnFamilyStore cfStore = defs.getColumnFamilyStore(MIGRATIONS_CF);
        QueryFilter filter = QueryFilter.getSliceFilter(dkey, new QueryPath(MIGRATIONS_CF), ByteBuffer.wrap(UUIDGen.decompose(start)), ByteBuffer.wrap(UUIDGen.decompose(end)), false, 1000);
        ColumnFamily cf = cfStore.getColumnFamily(filter);
        return cf.getSortedColumns();
    }

    public static ByteBuffer toUTF8Bytes(java.util.UUID version) {
        return ByteBuffer.wrap(version.toString().getBytes(Charsets.UTF_8));
    }

    public static boolean isLegalName(String s) {
        return s.matches(NAME_VALIDATOR_REGEX);
    }
}

