/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CLibrary {
    private static Logger logger = LoggerFactory.getLogger(CLibrary.class);
    private static final int MCL_CURRENT = 1;
    private static final int MCL_FUTURE = 2;
    private static final int ENOMEM = 12;

    private static native int mlockall(int var0) throws LastErrorException;

    private static native int munlockall() throws LastErrorException;

    private static native int link(String var0, String var1) throws LastErrorException;

    private static int errno(RuntimeException e) {
        assert (e instanceof LastErrorException);
        try {
            return ((LastErrorException)e).getErrorCode();
        }
        catch (NoSuchMethodError x) {
            logger.warn("Obsolete version of JNA present; unable to read errno. Upgrade to JNA 3.2.7 or later");
            return 0;
        }
    }

    private CLibrary() {
    }

    public static void tryMlockall() {
        block6: {
            try {
                int result = CLibrary.mlockall(1);
                assert (result == 0);
                logger.info("JNA mlockall successful");
            }
            catch (UnsatisfiedLinkError e) {
            }
            catch (RuntimeException e) {
                if (!(e instanceof LastErrorException)) {
                    throw e;
                }
                if (CLibrary.errno(e) == 12 && System.getProperty("os.name").toLowerCase().contains("linux")) {
                    logger.warn("Unable to lock JVM memory (ENOMEM). This can result in part of the JVM being swapped out, especially with mmapped I/O enabled. Increase RLIMIT_MEMLOCK or run Cassandra as root.");
                }
                if (System.getProperty("os.name").toLowerCase().contains("mac")) break block6;
                logger.warn("Unknown mlockall error " + CLibrary.errno(e));
            }
        }
    }

    public static void createHardLink(File sourceFile, File destinationFile) throws IOException {
        try {
            int result = CLibrary.link(sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath());
            assert (result == 0);
        }
        catch (UnsatisfiedLinkError e) {
            CLibrary.createHardLinkWithExec(sourceFile, destinationFile);
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            throw new IOException(String.format("Unable to create hard link from %s to %s (errno %d)", sourceFile, destinationFile, CLibrary.errno(e)));
        }
    }

    private static void createHardLinkWithExec(File sourceFile, File destinationFile) throws IOException {
        ProcessBuilder pb;
        String osname = System.getProperty("os.name");
        if (osname.startsWith("Windows")) {
            float osversion = Float.parseFloat(System.getProperty("os.version"));
            pb = osversion >= 6.0f ? new ProcessBuilder("cmd", "/c", "mklink", "/H", destinationFile.getAbsolutePath(), sourceFile.getAbsolutePath()) : new ProcessBuilder("fsutil", "hardlink", "create", destinationFile.getAbsolutePath(), sourceFile.getAbsolutePath());
        } else {
            pb = new ProcessBuilder("ln", sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath());
            pb.redirectErrorStream(true);
        }
        Process p = pb.start();
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Native.register((String)"c");
        }
        catch (NoClassDefFoundError e) {
            logger.info("JNA not found. Native methods will be disabled.");
        }
        catch (UnsatisfiedLinkError e) {
            logger.info("Unable to link C library. Native methods will be disabled.");
        }
        catch (NoSuchMethodError e) {
            logger.warn("Obsolete version of JNA present; unable to register C library. Upgrade to JNA 3.2.7 or later");
        }
    }
}

