/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.FBUtilities;

public class IndexHelper {
    public static void skipBloomFilter(DataInput in) throws IOException {
        int size = in.readInt();
        int skipped = in.skipBytes(size);
        if (skipped != size) {
            throw new EOFException("attempted to skip " + size + " bytes but only skipped " + skipped);
        }
    }

    public static void skipIndex(DataInput file) throws IOException {
        int columnIndexSize = file.readInt();
        if (file.skipBytes(columnIndexSize) != columnIndexSize) {
            throw new EOFException();
        }
    }

    public static ArrayList<IndexInfo> deserializeIndex(FileDataInput in) throws IOException {
        int columnIndexSize = in.readInt();
        if (columnIndexSize == 0) {
            return null;
        }
        ArrayList<IndexInfo> indexList = new ArrayList<IndexInfo>();
        FileMark mark = in.mark();
        while (in.bytesPastMark(mark) < columnIndexSize) {
            indexList.add(IndexInfo.deserialize(in));
        }
        assert (in.bytesPastMark(mark) == columnIndexSize);
        return indexList;
    }

    public static BloomFilter defreezeBloomFilter(DataInput file) throws IOException {
        int size = file.readInt();
        byte[] bytes = new byte[size];
        file.readFully(bytes);
        ByteArrayInputStream bufIn = new ByteArrayInputStream(bytes);
        return BloomFilter.serializer().deserialize(new DataInputStream(bufIn));
    }

    public static int indexFor(ByteBuffer name, List<IndexInfo> indexList, AbstractType comparator, boolean reversed) {
        if (name.remaining() == 0 && reversed) {
            return indexList.size() - 1;
        }
        IndexInfo target = new IndexInfo(name, name, 0L, 0L);
        int index = Collections.binarySearch(indexList, target, IndexHelper.getComparator(comparator));
        return index < 0 ? -1 * (index + 1) : index;
    }

    public static Comparator<IndexInfo> getComparator(final AbstractType nameComparator) {
        return new Comparator<IndexInfo>(){

            @Override
            public int compare(IndexInfo o1, IndexInfo o2) {
                return nameComparator.compare(o1.lastName, o2.lastName);
            }
        };
    }

    public static class IndexInfo {
        public final long width;
        public final ByteBuffer lastName;
        public final ByteBuffer firstName;
        public final long offset;

        public IndexInfo(ByteBuffer firstName, ByteBuffer lastName, long offset, long width) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.offset = offset;
            this.width = width;
        }

        public void serialize(DataOutput dos) throws IOException {
            FBUtilities.writeShortByteArray(this.firstName, dos);
            FBUtilities.writeShortByteArray(this.lastName, dos);
            dos.writeLong(this.offset);
            dos.writeLong(this.width);
        }

        public int serializedSize() {
            return 2 + this.firstName.remaining() + 2 + this.lastName.remaining() + 8 + 8;
        }

        public static IndexInfo deserialize(FileDataInput dis) throws IOException {
            return new IndexInfo(FBUtilities.readShortByteArray(dis), FBUtilities.readShortByteArray(dis), dis.readLong(), dis.readLong());
        }
    }
}

