/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.BytesToken;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang.ArrayUtils;

public abstract class AbstractByteOrderedPartitioner
implements IPartitioner<BytesToken> {
    public static final BytesToken MINIMUM = new BytesToken(ArrayUtils.EMPTY_BYTE_ARRAY);
    public static final BigInteger BYTE_MASK = new BigInteger("255");
    private final Token.TokenFactory<byte[]> tokenFactory = new Token.TokenFactory<byte[]>(){

        @Override
        public ByteBuffer toByteArray(Token<byte[]> bytesToken) {
            return ByteBuffer.wrap((byte[])bytesToken.token);
        }

        @Override
        public Token<byte[]> fromByteArray(ByteBuffer bytes) {
            return new BytesToken(bytes);
        }

        @Override
        public String toString(Token<byte[]> bytesToken) {
            return FBUtilities.bytesToHex((byte[])bytesToken.token);
        }

        @Override
        public Token<byte[]> fromString(String string) {
            return new BytesToken(FBUtilities.hexToBytes(string));
        }
    };

    @Override
    public DecoratedKey<BytesToken> decorateKey(ByteBuffer key) {
        return new DecoratedKey<BytesToken>(this.getToken(key), key);
    }

    @Override
    public DecoratedKey<BytesToken> convertFromDiskFormat(ByteBuffer key) {
        return new DecoratedKey<BytesToken>(this.getToken(key), key);
    }

    @Override
    public BytesToken midpoint(Token ltoken, Token rtoken) {
        ByteBuffer rb;
        int rl;
        ByteBuffer lb;
        int ll;
        if (ltoken.token instanceof byte[]) {
            ll = ((byte[])ltoken.token).length;
            lb = ByteBuffer.wrap((byte[])ltoken.token);
        } else {
            ll = ((ByteBuffer)ltoken.token).remaining();
            lb = (ByteBuffer)ltoken.token;
        }
        if (rtoken.token instanceof byte[]) {
            rl = ((byte[])rtoken.token).length;
            rb = ByteBuffer.wrap((byte[])rtoken.token);
        } else {
            rl = ((ByteBuffer)rtoken.token).remaining();
            rb = (ByteBuffer)rtoken.token;
        }
        int sigbytes = Math.max(ll, rl);
        BigInteger left = this.bigForBytes(lb, sigbytes);
        BigInteger right = this.bigForBytes(rb, sigbytes);
        Pair<BigInteger, Boolean> midpair = FBUtilities.midpoint(left, right, 8 * sigbytes);
        return new BytesToken(this.bytesForBig((BigInteger)midpair.left, sigbytes, (Boolean)midpair.right));
    }

    private BigInteger bigForBytes(ByteBuffer bytes, int sigbytes) {
        byte[] b = new byte[sigbytes];
        Arrays.fill(b, (byte)0);
        System.arraycopy(bytes.array(), bytes.position() + bytes.arrayOffset(), b, 0, bytes.remaining());
        return new BigInteger(1, b);
    }

    private byte[] bytesForBig(BigInteger big, int sigbytes, boolean remainder) {
        byte[] bytes = new byte[sigbytes + (remainder ? 1 : 0)];
        if (remainder) {
            int n = sigbytes;
            bytes[n] = (byte)(bytes[n] | 0x80);
        }
        for (int i = 0; i < sigbytes; ++i) {
            int maskpos = 8 * (sigbytes - (i + 1));
            bytes[i] = (byte)(big.and(BYTE_MASK.shiftLeft(maskpos)).shiftRight(maskpos).intValue() & 0xFF);
        }
        return bytes;
    }

    @Override
    public BytesToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public BytesToken getRandomToken() {
        Random r = new Random();
        byte[] buffer = new byte[16];
        r.nextBytes(buffer);
        return new BytesToken(buffer);
    }

    @Override
    public Token.TokenFactory<byte[]> getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public abstract BytesToken getToken(ByteBuffer var1);
}

