/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.SuperColumnSerializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperColumn
implements IColumn,
IColumnContainer {
    private static Logger logger_ = LoggerFactory.getLogger(SuperColumn.class);
    private ByteBuffer name_;
    private ConcurrentSkipListMap<ByteBuffer, IColumn> columns_;
    private AtomicInteger localDeletionTime = new AtomicInteger(Integer.MIN_VALUE);
    private AtomicLong markedForDeleteAt = new AtomicLong(Long.MIN_VALUE);

    public static SuperColumnSerializer serializer(AbstractType comparator) {
        return new SuperColumnSerializer(comparator);
    }

    public SuperColumn(ByteBuffer name, AbstractType comparator) {
        this(name, new ConcurrentSkipListMap<ByteBuffer, IColumn>(comparator));
    }

    private SuperColumn(ByteBuffer name, ConcurrentSkipListMap<ByteBuffer, IColumn> columns) {
        assert (name != null);
        assert (name.remaining() <= 65535);
        this.name_ = name;
        this.columns_ = columns;
    }

    @Override
    public AbstractType getComparator() {
        return (AbstractType)this.columns_.comparator();
    }

    public SuperColumn cloneMeShallow() {
        SuperColumn sc = new SuperColumn(this.name_, this.getComparator());
        sc.markForDeleteAt(this.localDeletionTime.get(), this.markedForDeleteAt.get());
        return sc;
    }

    public IColumn cloneMe() {
        SuperColumn sc = new SuperColumn(this.name_, new ConcurrentSkipListMap<ByteBuffer, IColumn>((SortedMap<ByteBuffer, IColumn>)this.columns_));
        sc.markForDeleteAt(this.localDeletionTime.get(), this.markedForDeleteAt.get());
        return sc;
    }

    @Override
    public boolean isMarkedForDelete() {
        return this.markedForDeleteAt.get() > Long.MIN_VALUE;
    }

    @Override
    public ByteBuffer name() {
        return this.name_;
    }

    @Override
    public Collection<IColumn> getSubColumns() {
        return this.columns_.values();
    }

    @Override
    public IColumn getSubColumn(ByteBuffer columnName) {
        IColumn column = this.columns_.get(columnName);
        assert (column == null || column instanceof Column);
        return column;
    }

    @Override
    public int size() {
        int size = 0;
        for (IColumn subColumn : this.getSubColumns()) {
            size += subColumn.serializedSize();
        }
        return size;
    }

    @Override
    public int serializedSize() {
        return 2 + this.name_.remaining() + 4 + 8 + 4 + this.size();
    }

    public void remove(ByteBuffer columnName) {
        this.columns_.remove(columnName);
    }

    @Override
    public long timestamp() {
        throw new UnsupportedOperationException("This operation is not supported for Super Columns.");
    }

    @Override
    public long mostRecentLiveChangeAt() {
        long max = Long.MIN_VALUE;
        for (IColumn column : this.columns_.values()) {
            if (column.isMarkedForDelete() || column.timestamp() <= max) continue;
            max = column.timestamp();
        }
        return max;
    }

    @Override
    public ByteBuffer value() {
        throw new UnsupportedOperationException("This operation is not supported for Super Columns.");
    }

    @Override
    public void addColumn(IColumn column) {
        assert (column instanceof Column) : "A super column can only contain simple columns";
        ByteBuffer name = column.name();
        IColumn oldColumn = this.columns_.putIfAbsent(name, column);
        if (oldColumn != null) {
            IColumn reconciledColumn = column.reconcile(oldColumn);
            while (!this.columns_.replace(name, oldColumn, reconciledColumn)) {
                oldColumn = this.columns_.get(name);
                reconciledColumn = column.reconcile(oldColumn);
            }
        }
    }

    public void putColumn(IColumn column) {
        assert (column instanceof SuperColumn);
        for (IColumn subColumn : column.getSubColumns()) {
            this.addColumn(subColumn);
        }
        FBUtilities.atomicSetMax(this.localDeletionTime, column.getLocalDeletionTime());
        FBUtilities.atomicSetMax(this.markedForDeleteAt, column.getMarkedForDeleteAt());
    }

    @Override
    public long getMarkedForDeleteAt() {
        return this.markedForDeleteAt.get();
    }

    @Override
    public IColumn diff(IColumn columnNew) {
        SuperColumn columnDiff = new SuperColumn(columnNew.name(), ((SuperColumn)columnNew).getComparator());
        if (columnNew.getMarkedForDeleteAt() > this.getMarkedForDeleteAt()) {
            columnDiff.markForDeleteAt(columnNew.getLocalDeletionTime(), columnNew.getMarkedForDeleteAt());
        }
        for (IColumn subColumn : columnNew.getSubColumns()) {
            IColumn columnInternal = this.columns_.get(subColumn.name());
            if (columnInternal == null) {
                columnDiff.addColumn(subColumn);
                continue;
            }
            IColumn subColumnDiff = columnInternal.diff(subColumn);
            if (subColumnDiff == null) continue;
            columnDiff.addColumn(subColumnDiff);
        }
        if (!columnDiff.getSubColumns().isEmpty() || columnNew.isMarkedForDelete()) {
            return columnDiff;
        }
        return null;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        assert (this.name_ != null);
        digest.update(this.name_.array(), this.name_.position() + this.name_.arrayOffset(), this.name_.remaining());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.markedForDeleteAt.get());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
        for (IColumn column : this.columns_.values()) {
            column.updateDigest(digest);
        }
    }

    @Override
    public String getString(AbstractType comparator) {
        StringBuilder sb = new StringBuilder();
        sb.append("SuperColumn(");
        sb.append(comparator.getString(this.name_));
        if (this.isMarkedForDelete()) {
            sb.append(" -delete at ").append(this.getMarkedForDeleteAt()).append("-");
        }
        sb.append(" [");
        sb.append(this.getComparator().getColumnsString(this.columns_.values()));
        sb.append("])");
        return sb.toString();
    }

    @Override
    public boolean isLive() {
        return this.mostRecentLiveChangeAt() > this.markedForDeleteAt.get();
    }

    @Override
    public int getLocalDeletionTime() {
        return this.localDeletionTime.get();
    }

    @Deprecated
    public void markForDeleteAt(int localDeleteTime, long timestamp) {
        this.localDeletionTime.set(localDeleteTime);
        this.markedForDeleteAt.set(timestamp);
    }

    @Override
    public IColumn deepCopy() {
        SuperColumn sc = new SuperColumn(ByteBufferUtil.clone(this.name_), this.getComparator());
        sc.localDeletionTime = this.localDeletionTime;
        sc.markedForDeleteAt = this.markedForDeleteAt;
        for (Map.Entry<ByteBuffer, IColumn> c : this.columns_.entrySet()) {
            sc.addColumn(c.getValue().deepCopy());
        }
        return sc;
    }

    @Override
    public IColumn reconcile(IColumn c) {
        throw new UnsupportedOperationException("This operation is unsupported on super columns.");
    }
}

