/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundTcpConnection
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(OutboundTcpConnection.class);
    private static final ByteBuffer CLOSE_SENTINEL = ByteBuffer.allocate(0);
    private static final int OPEN_RETRY_DELAY = 100;
    private final InetAddress endpoint;
    private final BlockingQueue<ByteBuffer> queue = new LinkedBlockingQueue<ByteBuffer>();
    private DataOutputStream output;
    private Socket socket;
    private long completedCount;

    public OutboundTcpConnection(InetAddress remoteEp) {
        super("WRITE-" + remoteEp);
        this.endpoint = remoteEp;
    }

    public void write(ByteBuffer buffer) {
        try {
            this.queue.put(buffer);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    void closeSocket() {
        this.queue.clear();
        this.write(CLOSE_SENTINEL);
    }

    @Override
    public void run() {
        while (true) {
            ByteBuffer bb;
            if ((bb = this.take()) == CLOSE_SENTINEL) {
                this.disconnect();
                continue;
            }
            if (this.socket != null || this.connect()) {
                this.writeConnected(bb);
                continue;
            }
            this.queue.clear();
        }
    }

    public int getPendingMessages() {
        return this.queue.size();
    }

    public long getCompletedMesssages() {
        return this.completedCount;
    }

    private void writeConnected(ByteBuffer bb) {
        try {
            this.output.write(bb.array(), bb.position() + bb.arrayOffset(), bb.limit() + bb.arrayOffset());
            if (this.queue.peek() == null) {
                this.output.flush();
            }
        }
        catch (IOException e) {
            logger.info("error writing to " + this.endpoint);
            logger.debug("error was ", (Throwable)e);
            this.disconnect();
        }
    }

    private void disconnect() {
        if (this.socket != null) {
            block3: {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("exception closing connection to " + this.endpoint, (Throwable)e);
                }
            }
            this.output = null;
            this.socket = null;
        }
    }

    private ByteBuffer take() {
        ByteBuffer bb;
        try {
            bb = this.queue.take();
            ++this.completedCount;
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        return bb;
    }

    private boolean connect() {
        if (logger.isDebugEnabled()) {
            logger.debug("attempting to connect to " + this.endpoint);
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + DatabaseDescriptor.getRpcTimeout()) {
            try {
                this.socket = new Socket(this.endpoint, DatabaseDescriptor.getStoragePort(), FBUtilities.getLocalAddress(), 0);
                this.socket.setKeepAlive(true);
                this.socket.setTcpNoDelay(true);
                this.output = new DataOutputStream(this.socket.getOutputStream());
                return true;
            }
            catch (IOException e) {
                this.socket = null;
                if (logger.isTraceEnabled()) {
                    logger.trace("unable to connect to " + this.endpoint, (Throwable)e);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    throw new AssertionError((Object)e1);
                }
            }
        }
        return false;
    }
}

