/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.File;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableTracker;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableDeletingReference
extends PhantomReference<SSTableReader> {
    private static final Logger logger = LoggerFactory.getLogger(SSTableDeletingReference.class);
    public static final int RETRY_DELAY = 10000;
    private final SSTableTracker tracker;
    public final Descriptor desc;
    public final Set<Component> components;
    private final long size;
    private boolean deleteOnCleanup;

    SSTableDeletingReference(SSTableTracker tracker, SSTableReader referent, ReferenceQueue<? super SSTableReader> q) {
        super(referent, q);
        this.tracker = tracker;
        this.desc = referent.descriptor;
        this.components = referent.components;
        this.size = referent.bytesOnDisk();
    }

    public void deleteOnCleanup() {
        this.deleteOnCleanup = true;
    }

    public void cleanup() throws IOException {
        if (this.deleteOnCleanup) {
            StorageService.scheduledTasks.schedule(new CleanupTask(), 10000L, TimeUnit.MILLISECONDS);
        }
    }

    private class CleanupTask
    implements Runnable {
        int attempts = 0;

        private CleanupTask() {
        }

        @Override
        public void run() {
            File datafile = new File(SSTableDeletingReference.this.desc.filenameFor(Component.DATA));
            if (!datafile.delete()) {
                if (this.attempts++ < 10) {
                    StorageService.scheduledTasks.schedule(this, 10000L, TimeUnit.MILLISECONDS);
                    return;
                }
                logger.error("Unable to delete " + datafile + " (it will be removed on server restart)");
                return;
            }
            SSTableDeletingReference.this.components.remove(Component.DATA);
            SSTable.delete(SSTableDeletingReference.this.desc, SSTableDeletingReference.this.components);
            SSTableDeletingReference.this.tracker.spaceReclaimed(SSTableDeletingReference.this.size);
        }
    }
}

