/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.AbstractCompactedRow;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrecompactedRow
extends AbstractCompactedRow {
    private static Logger logger = LoggerFactory.getLogger(PrecompactedRow.class);
    private final DataOutputBuffer buffer;
    private int columnCount = 0;

    public PrecompactedRow(DecoratedKey key, DataOutputBuffer buffer) {
        super(key);
        this.buffer = buffer;
    }

    public PrecompactedRow(ColumnFamilyStore cfStore, List<SSTableIdentityIterator> rows, boolean major, int gcBefore) {
        super(rows.get(0).getKey());
        boolean shouldPurge;
        this.buffer = new DataOutputBuffer();
        HashSet<SSTable> sstables = new HashSet<SSTable>();
        for (SSTableIdentityIterator row : rows) {
            sstables.add(row.sstable);
        }
        boolean bl = shouldPurge = major || !cfStore.isKeyInRemainingSSTables(this.key, sstables);
        if (rows.size() > 1 || shouldPurge) {
            ColumnFamily cfPurged;
            ColumnFamily cf = null;
            for (SSTableIdentityIterator row : rows) {
                ColumnFamily thisCF;
                try {
                    thisCF = row.getColumnFamilyWithColumns();
                }
                catch (IOException e) {
                    logger.error("Skipping row " + this.key + " in " + row.getPath(), (Throwable)e);
                    continue;
                }
                if (cf == null) {
                    cf = thisCF;
                    continue;
                }
                cf.addAll(thisCF);
            }
            ColumnFamily columnFamily = cfPurged = shouldPurge ? ColumnFamilyStore.removeDeleted(cf, gcBefore) : cf;
            if (cfPurged == null) {
                return;
            }
            this.columnCount = ColumnFamily.serializer().serializeWithIndexes(cfPurged, this.buffer);
        } else {
            assert (rows.size() == 1);
            try {
                rows.get(0).echoData(this.buffer);
                this.columnCount = rows.get((int)0).columnCount;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.buffer.getLength());
        out.write(this.buffer.getData(), 0, this.buffer.getLength());
    }

    @Override
    public void update(MessageDigest digest) {
        digest.update(this.buffer.getData(), 0, this.buffer.getLength());
    }

    @Override
    public boolean isEmpty() {
        return this.buffer.getLength() == 0;
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }
}

