/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.ICompactSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EndpointStateSerializer
implements ICompactSerializer<EndpointState> {
    private static Logger logger_ = LoggerFactory.getLogger(EndpointStateSerializer.class);

    EndpointStateSerializer() {
    }

    @Override
    public void serialize(EndpointState epState, DataOutputStream dos) throws IOException {
        HeartBeatState hbState = epState.getHeartBeatState();
        HeartBeatState.serializer().serialize(hbState, dos);
        int size = epState.applicationState_.size();
        dos.writeInt(size);
        for (Map.Entry<ApplicationState, VersionedValue> entry : epState.applicationState_.entrySet()) {
            VersionedValue value = entry.getValue();
            if (value == null) continue;
            dos.writeInt(entry.getKey().ordinal());
            VersionedValue.serializer.serialize(value, dos);
        }
    }

    @Override
    public EndpointState deserialize(DataInputStream dis) throws IOException {
        HeartBeatState hbState = HeartBeatState.serializer().deserialize(dis);
        EndpointState epState = new EndpointState(hbState);
        int appStateSize = dis.readInt();
        for (int i = 0; i < appStateSize && dis.available() != 0; ++i) {
            int key = dis.readInt();
            VersionedValue value = VersionedValue.serializer.deserialize(dis);
            epState.addApplicationState(Gossiper.STATES[key], value);
        }
        return epState;
    }
}

