/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

public class LongType
extends AbstractType {
    public static final LongType instance = new LongType();

    LongType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1.remaining() == 0) {
            return o2.remaining() == 0 ? 0 : -1;
        }
        if (o2.remaining() == 0) {
            return 1;
        }
        int diff = o1.array()[o1.position() + o1.arrayOffset()] - o2.array()[o2.position() + o2.arrayOffset()];
        if (diff != 0) {
            return diff;
        }
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 8) {
            throw new MarshalException("A long is exactly 8 bytes: " + bytes.remaining());
        }
        return String.valueOf(bytes.getLong(bytes.position() + bytes.arrayOffset()));
    }

    @Override
    public ByteBuffer fromString(String source) {
        long longType;
        try {
            longType = Long.parseLong(source);
        }
        catch (Exception e) {
            throw new RuntimeException("'" + source + "' could not be translated into a LongType.");
        }
        return FBUtilities.toByteBuffer(longType);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 8 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 8 or 0 byte long (%d)", bytes.remaining()));
        }
    }
}

