/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.utils.FBUtilities;

class RowMutationSerializer
implements ICompactSerializer<RowMutation> {
    RowMutationSerializer() {
    }

    private void freezeTheMaps(Map<Integer, ColumnFamily> map, DataOutputStream dos) throws IOException {
        int size = map.size();
        dos.writeInt(size);
        if (size > 0) {
            for (Map.Entry<Integer, ColumnFamily> entry : map.entrySet()) {
                dos.writeInt(entry.getKey());
                ColumnFamily.serializer().serialize(entry.getValue(), (DataOutput)dos);
            }
        }
    }

    @Override
    public void serialize(RowMutation rm, DataOutputStream dos) throws IOException {
        dos.writeUTF(rm.getTable());
        FBUtilities.writeShortByteArray(rm.key(), dos);
        this.freezeTheMaps(rm.modifications_, dos);
    }

    private Map<Integer, ColumnFamily> defreezeTheMaps(DataInputStream dis) throws IOException {
        HashMap<Integer, ColumnFamily> map = new HashMap<Integer, ColumnFamily>();
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            Integer cfid = dis.readInt();
            ColumnFamily cf = ColumnFamily.serializer().deserialize(dis);
            map.put(cfid, cf);
        }
        return map;
    }

    @Override
    public RowMutation deserialize(DataInputStream dis) throws IOException {
        String table = dis.readUTF();
        ByteBuffer key = FBUtilities.readShortByteArray(dis);
        Map<Integer, ColumnFamily> modifications = this.defreezeTheMaps(dis);
        return new RowMutation(table, key, modifications);
    }
}

