/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.utils.FBUtilities;

class ReadResponseSerializer
implements ICompactSerializer<ReadResponse> {
    ReadResponseSerializer() {
    }

    @Override
    public void serialize(ReadResponse rm, DataOutputStream dos) throws IOException {
        dos.writeInt(rm.isDigestQuery() ? rm.digest().remaining() : 0);
        ByteBuffer buffer = rm.isDigestQuery() ? rm.digest() : FBUtilities.EMPTY_BYTE_BUFFER;
        dos.write(buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.remaining());
        dos.writeBoolean(rm.isDigestQuery());
        if (!rm.isDigestQuery()) {
            Row.serializer().serialize(rm.row(), dos);
        }
    }

    @Override
    public ReadResponse deserialize(DataInputStream dis) throws IOException {
        byte[] digest = null;
        int digestSize = dis.readInt();
        if (digestSize > 0) {
            digest = new byte[digestSize];
            dis.readFully(digest, 0, digestSize);
        }
        boolean isDigest = dis.readBoolean();
        assert (isDigest == digestSize > 0);
        Row row = null;
        if (!isDigest) {
            row = Row.serializer().deserialize(dis);
        }
        return isDigest ? new ReadResponse(ByteBuffer.wrap(digest)) : new ReadResponse(row);
    }
}

