/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.cassandra.auth.SimpleAuthenticator;
import org.apache.cassandra.auth.SimpleAuthority;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.RawColumnFamily;
import org.apache.cassandra.config.RawKeyspace;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.SkipNullRepresenter;
import org.apache.cassandra.utils.XMLUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.yaml.snakeyaml.Dumper;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class Converter {
    private static Config conf = new Config();

    private static List<RawKeyspace> readTablesFromXml(XMLUtils xmlUtils) throws ConfigurationException {
        ArrayList<RawKeyspace> keyspaces = new ArrayList<RawKeyspace>();
        try {
            String endPointSnitchClassName = null;
            NodeList tablesxml = xmlUtils.getRequestedNodeList("/Storage/Keyspaces/Keyspace");
            String gcGrace = xmlUtils.getNodeValue("/Storage/GCGraceSeconds");
            int gc_grace_seconds = 864000;
            if (gcGrace != null) {
                gc_grace_seconds = Integer.parseInt(gcGrace);
            }
            String lifetime = xmlUtils.getNodeValue("/Storage/MemtableFlushAfterMinutes");
            int memtime = 60;
            if (lifetime != null) {
                memtime = Integer.parseInt(lifetime);
            }
            String memtableSize = xmlUtils.getNodeValue("/Storage/MemtableThroughputInMB");
            int memsize = CFMetaData.DEFAULT_MEMTABLE_THROUGHPUT_IN_MB;
            if (memtableSize != null) {
                memsize = Integer.parseInt(memtableSize);
            }
            String memtableOps = xmlUtils.getNodeValue("/Storage/MemtableOperationsInMillions");
            double memops = CFMetaData.DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS;
            if (memtableOps != null) {
                memops = Double.parseDouble(memtableOps);
            }
            int size = tablesxml.getLength();
            for (int i = 0; i < size; ++i) {
                RawKeyspace ks = new RawKeyspace();
                Node table = tablesxml.item(i);
                ks.name = XMLUtils.getAttributeValue(table, "Name");
                String value = xmlUtils.getNodeValue("/Storage/Keyspaces/Keyspace[@Name='" + ks.name + "']/EndPointSnitch");
                if (endPointSnitchClassName == null) {
                    endPointSnitchClassName = value;
                } else if (!endPointSnitchClassName.equals(value)) {
                    throw new ConfigurationException("ERROR : EndPointSnitch is global in 0.7 -- multiple choices present.");
                }
                ks.replica_placement_strategy = xmlUtils.getNodeValue("/Storage/Keyspaces/Keyspace[@Name='" + ks.name + "']/ReplicaPlacementStrategy");
                value = xmlUtils.getNodeValue("/Storage/Keyspaces/Keyspace[@Name='" + ks.name + "']/ReplicationFactor");
                if (value != null) {
                    ks.replication_factor = Integer.parseInt(value);
                }
                String xqlTable = "/Storage/Keyspaces/Keyspace[@Name='" + ks.name + "']/";
                NodeList columnFamilies = xmlUtils.getRequestedNodeList(xqlTable + "ColumnFamily");
                int size2 = columnFamilies.getLength();
                ks.column_families = new RawColumnFamily[size2];
                for (int j = 0; j < size2; ++j) {
                    Node columnFamily = columnFamilies.item(j);
                    ks.column_families[j] = new RawColumnFamily();
                    ks.column_families[j].name = XMLUtils.getAttributeValue(columnFamily, "Name");
                    String xqlCF = xqlTable + "ColumnFamily[@Name='" + ks.column_families[j].name + "']/";
                    ks.column_families[j].column_type = ColumnFamilyType.create(XMLUtils.getAttributeValue(columnFamily, "ColumnType"));
                    ks.column_families[j].compare_with = XMLUtils.getAttributeValue(columnFamily, "CompareWith");
                    if (ks.column_families[j].column_type != null && ks.column_families[j].column_type == ColumnFamilyType.Super) {
                        ks.column_families[j].compare_subcolumns_with = XMLUtils.getAttributeValue(columnFamily, "CompareSubcolumnsWith");
                    }
                    if ((value = XMLUtils.getAttributeValue(columnFamily, "KeysCached")) != null) {
                        ks.column_families[j].keys_cached = FBUtilities.parseDoubleOrPercent(value);
                    }
                    if ((value = XMLUtils.getAttributeValue(columnFamily, "RowsCached")) != null) {
                        ks.column_families[j].rows_cached = FBUtilities.parseDoubleOrPercent(value);
                    }
                    if ((value = XMLUtils.getAttributeValue(columnFamily, "RowCacheSavePeriodInSeconds")) != null) {
                        ks.column_families[j].row_cache_save_period_in_seconds = Integer.parseInt(value);
                    }
                    if ((value = XMLUtils.getAttributeValue(columnFamily, "KeyCacheSavePeriodInSeconds")) != null) {
                        ks.column_families[j].key_cache_save_period_in_seconds = Integer.parseInt(value);
                    }
                    if ((value = XMLUtils.getAttributeValue(columnFamily, "ReadRepairChance")) != null) {
                        ks.column_families[j].read_repair_chance = FBUtilities.parseDoubleOrPercent(value);
                    }
                    ks.column_families[j].gc_grace_seconds = gc_grace_seconds;
                    ks.column_families[j].memtable_flush_after_mins = memtime;
                    ks.column_families[j].memtable_throughput_in_mb = memsize;
                    ks.column_families[j].memtable_operations_in_millions = memops;
                    ks.column_families[j].comment = xmlUtils.getNodeValue(xqlCF + "Comment");
                }
                keyspaces.add(ks);
            }
            if (endPointSnitchClassName.equals("org.apache.cassandra.locator.EndPointSnitch")) {
                endPointSnitchClassName = "org.apache.cassandra.locator.RackInferringSnitch";
                System.out.println("WARN : org.apache.cassandra.locator.EndPointSnitch has been replaced by org.apache.cassandra.locator.RackInferringSnitch");
            } else if (endPointSnitchClassName.equals("org.apache.cassandra.locator.PropertyFileEndpointSnitch")) {
                endPointSnitchClassName = "org.apache.cassandra.locator.PropertyFileSnitch";
                System.out.println("WARN : org.apache.cassandra.locator.PropertyFileEndpointSnich has been replaced by org.apache.cassandra.locator.PropertyFileSnitch");
            } else {
                System.out.println("INFO : EndPointSnitch is global in 0.7 and may need to be updated.");
            }
            Converter.conf.endpoint_snitch = endPointSnitchClassName;
            return keyspaces;
        }
        catch (XPathExpressionException e) {
            throw new ConfigurationException("XPath expression error.");
        }
        catch (TransformerException e) {
            throw new ConfigurationException("Error occurred during the transformation process.");
        }
    }

    private static void loadPreviousConfig(String config) throws ConfigurationException {
        try {
            String columnIndexSize;
            String autoBootstr;
            String framedRaw;
            String port;
            String bmtThresh;
            String rawSlicedBuffer;
            String rawWriters;
            String rawReaders;
            XMLUtils xmlUtils = new XMLUtils(config);
            Converter.conf.cluster_name = xmlUtils.getNodeValue("/Storage/ClusterName");
            String syncRaw = xmlUtils.getNodeValue("/Storage/CommitLogSync");
            Converter.conf.commitlog_sync = Config.CommitLogSync.valueOf(syncRaw);
            if (Converter.conf.commitlog_sync != null) {
                if (Converter.conf.commitlog_sync == Config.CommitLogSync.batch) {
                    Converter.conf.commitlog_sync_batch_window_in_ms = Double.valueOf(xmlUtils.getNodeValue("/Storage/CommitLogSyncBatchWindowInMS"));
                } else {
                    Converter.conf.commitlog_sync_period_in_ms = Integer.valueOf(xmlUtils.getNodeValue("/Storage/CommitLogSyncPeriodInMS"));
                }
            }
            String modeRaw = xmlUtils.getNodeValue("/Storage/DiskAccessMode");
            Converter.conf.disk_access_mode = Config.DiskAccessMode.valueOf(modeRaw);
            Converter.conf.authenticator = xmlUtils.getNodeValue("/Storage/Authenticator");
            if (Converter.conf.authenticator != null && Converter.conf.authenticator.equals(SimpleAuthenticator.class.getName())) {
                Converter.conf.authority = SimpleAuthority.class.getName();
            }
            Converter.conf.partitioner = xmlUtils.getNodeValue("/Storage/Partitioner");
            Converter.conf.job_tracker_host = xmlUtils.getNodeValue("/Storage/JobTrackerHost");
            Converter.conf.job_jar_file_location = xmlUtils.getNodeValue("/Storage/JobJarFileLocation");
            Converter.conf.initial_token = xmlUtils.getNodeValue("/Storage/InitialToken");
            String rpcTimeout = xmlUtils.getNodeValue("/Storage/RpcTimeoutInMillis");
            if (rpcTimeout != null) {
                Converter.conf.rpc_timeout_in_ms = Long.parseLong(rpcTimeout);
            }
            if ((rawReaders = xmlUtils.getNodeValue("/Storage/ConcurrentReads")) != null) {
                Converter.conf.concurrent_reads = Integer.parseInt(rawReaders);
            }
            if ((rawWriters = xmlUtils.getNodeValue("/Storage/ConcurrentWrites")) != null) {
                Converter.conf.concurrent_writes = Integer.parseInt(rawWriters);
            }
            if ((rawSlicedBuffer = xmlUtils.getNodeValue("/Storage/SlicedBufferSizeInKB")) != null) {
                Converter.conf.sliced_buffer_size_in_kb = Integer.parseInt(rawSlicedBuffer);
            }
            if ((bmtThresh = xmlUtils.getNodeValue("/Storage/BinaryMemtableThroughputInMB")) != null) {
                Converter.conf.binary_memtable_throughput_in_mb = Integer.parseInt(bmtThresh);
            }
            if ((port = xmlUtils.getNodeValue("/Storage/StoragePort")) != null) {
                Converter.conf.storage_port = Integer.parseInt(port);
            }
            Converter.conf.listen_address = xmlUtils.getNodeValue("/Storage/ListenAddress");
            Converter.conf.rpc_address = xmlUtils.getNodeValue("/Storage/RPCAddress");
            port = xmlUtils.getNodeValue("/Storage/RPCPort");
            if (port != null) {
                Converter.conf.rpc_port = Integer.parseInt(port);
            }
            if ((framedRaw = xmlUtils.getNodeValue("/Storage/ThriftFramedTransport")) != null && !Boolean.valueOf(framedRaw).booleanValue()) {
                System.out.println("WARN : Cassandra uses a Thrift framed Transport by default in 0.7! Clients will need to match.");
            }
            Converter.conf.thrift_framed_transport_size_in_mb = 15;
            String sbc = xmlUtils.getNodeValue("/Storage/SnapshotBeforeCompaction");
            if (sbc != null) {
                Converter.conf.snapshot_before_compaction = Boolean.valueOf(sbc);
            }
            if ((autoBootstr = xmlUtils.getNodeValue("/Storage/AutoBootstrap")) != null) {
                Converter.conf.auto_bootstrap = Boolean.valueOf(autoBootstr);
            }
            if ((columnIndexSize = xmlUtils.getNodeValue("/Storage/ColumnIndexSizeInKB")) != null) {
                Converter.conf.column_index_size_in_kb = Integer.parseInt(columnIndexSize);
            }
            Converter.conf.data_file_directories = xmlUtils.getNodeValues("/Storage/DataFileDirectories/DataFileDirectory");
            Converter.conf.commitlog_directory = xmlUtils.getNodeValue("/Storage/CommitLogDirectory");
            Converter.conf.saved_caches_directory = xmlUtils.getNodeValue("/Storage/SavedCachesDirectory");
            String value = xmlUtils.getNodeValue("/Storage/CommitLogRotationThresholdInMB");
            if (value != null) {
                Converter.conf.commitlog_rotation_threshold_in_mb = Integer.parseInt(value);
            }
            Converter.conf.seeds = xmlUtils.getNodeValues("/Storage/Seeds/Seed");
            Converter.conf.keyspaces = Converter.readTablesFromXml(xmlUtils);
        }
        catch (ParserConfigurationException e) {
            System.out.println("Parser error during previous config load.");
            throw new ConfigurationException("Parser error during previous config load.");
        }
        catch (SAXException e) {
            System.out.println("SAX error during previous config load.");
            throw new ConfigurationException("SAX error during previous config load.");
        }
        catch (IOException e) {
            System.out.println("File I/O error during previous config load.");
            throw new ConfigurationException("File I/O error during previous config load.");
        }
        catch (XPathExpressionException e) {
            System.out.println("XPath error during previous config load.");
            throw new ConfigurationException("XPath error during previous config load.");
        }
    }

    private static void dumpConfig(String outfile) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        SkipNullRepresenter representer = new SkipNullRepresenter();
        representer.addClassTag(Config.class, Tag.MAP);
        representer.addClassTag(RawColumnFamily.class, Tag.MAP);
        Dumper dumper = new Dumper((Representer)representer, options);
        Yaml yaml = new Yaml(dumper);
        String output = yaml.dump((Object)conf);
        BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
        out.write("# Cassandra YAML generated from previous config\n");
        out.write("# Configuration wiki: http://wiki.apache.org/cassandra/StorageConfiguration\n");
        out.write(output);
        out.close();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new IllegalArgumentException("usage: config-converter oldfile newfile");
        }
        String oldConfigName = args[0];
        String newConfigName = args[1];
        if (!new File(oldConfigName).exists()) {
            throw new IllegalArgumentException(String.format("%s does not exist", oldConfigName));
        }
        Converter.loadPreviousConfig(oldConfigName);
        Converter.dumpConfig(newConfigName);
    }
}

