/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;

public abstract class ReducingIterator<T>
extends AbstractIterator<T>
implements Iterator<T>,
Iterable<T> {
    protected Iterator<T> source;
    protected T last;

    public ReducingIterator(Iterator<T> source) {
        this.source = source;
    }

    public abstract void reduce(T var1);

    protected abstract T getReduced();

    protected boolean isEqual(T o1, T o2) {
        return o1.equals(o2);
    }

    protected T computeNext() {
        if (this.last == null && !this.source.hasNext()) {
            return (T)this.endOfData();
        }
        boolean keyChanged = false;
        while (!keyChanged) {
            if (this.last != null) {
                this.reduce(this.last);
            }
            if (!this.source.hasNext()) {
                this.last = null;
                break;
            }
            T current = this.source.next();
            if (this.last != null && !this.isEqual(current, this.last)) {
                keyChanged = true;
            }
            this.last = current;
        }
        return this.getReduced();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

