/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.log4j.Logger;

public class FileUtils {
    private static Logger logger_ = Logger.getLogger(FileUtils.class);
    private static final DecimalFormat df_ = new DecimalFormat("#.##");
    private static final double kb_ = 1024.0;
    private static final double mb_ = 1048576.0;
    private static final double gb_ = 1.073741824E9;
    private static final double tb_ = 1.099511627776E12;
    private static ExecutorService deleter_ = new DebuggableThreadPoolExecutor("FILEUTILS-DELETE-POOL");

    public static void shutdown() {
        deleter_.shutdownNow();
    }

    public static void deleteWithConfirm(File file) throws IOException {
        assert (file.exists()) : "attempted to delete non-existing file " + file.getName();
        if (!file.delete()) {
            throw new IOException("Failed to delete " + file.getName());
        }
    }

    public static void createDirectory(String directory) throws IOException {
        File file = new File(directory);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("unable to mkdirs " + directory);
        }
    }

    public static void createFile(String directory) throws IOException {
        File file = new File(directory);
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    public static boolean isExists(String filename) throws IOException {
        File file = new File(filename);
        return file.exists();
    }

    public static boolean delete(String file) {
        File f = new File(file);
        return f.delete();
    }

    public static void deleteAsync(String file) throws IOException {
        File f = new File(file);
        Deleter deleter = new Deleter(f);
        deleter_.submit(deleter);
    }

    public static boolean delete(List<String> files) throws IOException {
        boolean bVal = true;
        for (int i = 0; i < files.size(); ++i) {
            String file = files.get(i);
            bVal = FileUtils.delete(file);
            if (!bVal) continue;
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Deleted file " + file));
            }
            files.remove(i);
        }
        return bVal;
    }

    public static void delete(File[] files) throws IOException {
        for (File file : files) {
            file.delete();
        }
    }

    public static String stringifyFileSize(double value) {
        double d = 0.0;
        if (value >= 1.099511627776E12) {
            d = value / 1.099511627776E12;
            String val = df_.format(d);
            return val + " TB";
        }
        if (value >= 1.073741824E9) {
            d = value / 1.073741824E9;
            String val = df_.format(d);
            return val + " GB";
        }
        if (value >= 1048576.0) {
            d = value / 1048576.0;
            String val = df_.format(d);
            return val + " MB";
        }
        if (value >= 1024.0) {
            d = value / 1024.0;
            String val = df_.format(d);
            return val + " KB";
        }
        String val = df_.format(value);
        return val + " bytes.";
    }

    public static double stringToFileSize(String value) {
        String[] peices = value.split(" ");
        double d = Double.valueOf(peices[0]);
        d = peices[1].equals("TB") ? (d *= 1.099511627776E12) : (peices[1].equals("GB") ? (d *= 1.073741824E9) : (peices[1].equals("MB") ? (d *= 1048576.0) : (peices[1].equals("KB") ? (d *= 1024.0) : (d *= 1.0))));
        return d;
    }

    public static long getUsedDiskSpaceForPath(String path) {
        File file = new File(path);
        if (file.isFile()) {
            return file.length();
        }
        long diskSpace = 0L;
        for (File childFile : file.listFiles()) {
            diskSpace += FileUtils.getUsedDiskSpaceForPath(childFile.getPath());
        }
        return diskSpace;
    }

    public static long getUsedDiskSpace() {
        String[] directories;
        long diskSpace = 0L;
        for (String directory : directories = DatabaseDescriptor.getAllDataFileLocations()) {
            diskSpace += FileUtils.getUsedDiskSpaceForPath(directory);
        }
        String value = df_.format(diskSpace);
        return Long.parseLong(value);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void createHardLink(File sourceFile, File destinationFile) throws IOException {
        ProcessBuilder pb;
        String osname = System.getProperty("os.name");
        if (osname.startsWith("Windows")) {
            float osversion = Float.parseFloat(System.getProperty("os.version"));
            pb = osversion >= 6.0f ? new ProcessBuilder("cmd", "/c", "mklink", "/H", destinationFile.getAbsolutePath(), sourceFile.getAbsolutePath()) : new ProcessBuilder("fsutil", "hardlink", "create", destinationFile.getAbsolutePath(), sourceFile.getAbsolutePath());
        } else {
            pb = new ProcessBuilder("ln", sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath());
            pb.redirectErrorStream(true);
        }
        Process p = pb.start();
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class FileComparator
    implements Comparator<File> {
        @Override
        public int compare(File f, File f2) {
            return (int)(f.lastModified() - f2.lastModified());
        }
    }

    public static class Deleter
    implements Runnable {
        File file_ = null;

        public Deleter(File f) {
            this.file_ = f;
        }

        @Override
        public void run() {
            if (this.file_ == null) {
                return;
            }
            logger_.info((Object)("*** Deleting " + this.file_.getName() + " ***"));
            if (!this.file_.delete()) {
                logger_.warn((Object)("Warning : Unable to delete file " + this.file_.getAbsolutePath()));
            }
        }
    }
}

