/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.Arrays;
import org.apache.cassandra.utils.FastHash;

public abstract class FastObjectHash<T>
extends FastHash {
    static final long serialVersionUID = -3461112548087185871L;
    protected transient Object[] set_;
    protected static final Object REMOVED = new Object();
    protected static final Object FREE = new Object();

    public FastObjectHash() {
    }

    public FastObjectHash(int initialCapacity) {
        super(initialCapacity);
    }

    public FastObjectHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    public FastObjectHash<T> clone() {
        FastObjectHash h = (FastObjectHash)super.clone();
        h.set_ = (Object[])this.set_.clone();
        return h;
    }

    abstract void addEntry(Object var1, int var2);

    abstract void removeEntry(Object var1, int var2);

    @Override
    protected int capacity() {
        return this.set_.length;
    }

    @Override
    protected void removeAt(int index) {
        this.set_[index] = REMOVED;
        super.removeAt(index);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this.set_ = new Object[capacity];
        Arrays.fill(this.set_, FREE);
        return capacity;
    }

    public boolean contains(Object obj) {
        return this.index(obj) >= 0;
    }

    protected int index(Object obj) {
        Object[] set = this.set_;
        int length = set.length;
        int hash = obj.hashCode() & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (cur == FREE) {
            return -1;
        }
        if (cur == REMOVED || cur.equals(obj)) {
            int probe = 1 + hash % (length - 2);
            while (!(cur == FREE || cur != REMOVED && cur.equals(obj))) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
        }
        return cur == FREE ? -1 : index;
    }

    protected int insertionIndex(T obj) {
        Object[] set = this.set_;
        int length = set.length;
        int hash = obj.hashCode() & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (cur == FREE) {
            return index;
        }
        if (cur != REMOVED && cur.equals(obj)) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != FREE && cur != REMOVED && !cur.equals(obj));
        }
        if (cur == REMOVED) {
            int firstRemoved = index;
            while (!(cur == FREE || cur != REMOVED && cur.equals(obj))) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != FREE ? -index - 1 : firstRemoved;
        }
        return cur != FREE ? -index - 1 : index;
    }

    public final int computeHashCode(T o) {
        return o == null ? 0 : o.hashCode();
    }

    public final boolean equals(T o1, T o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + o1 + "; object #2 =" + o2);
    }
}

