/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.MultiThreadedStage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.concurrent.ThreadFactoryImpl;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.BinaryVerbHandler;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataFileVerbHandler;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadRepairVerbHandler;
import org.apache.cassandra.db.ReadVerbHandler;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutationVerbHandler;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.dht.BootStrapper;
import org.apache.cassandra.dht.BootstrapInitiateMessage;
import org.apache.cassandra.dht.BootstrapMetadataVerbHandler;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndPointStateChangeSubscriber;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndPointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.SelectorManager;
import org.apache.cassandra.net.io.StreamContextManager;
import org.apache.cassandra.service.ConsistencyManager;
import org.apache.cassandra.service.LoadDisseminator;
import org.apache.cassandra.service.LoadInfo;
import org.apache.cassandra.service.RangeVerbHandler;
import org.apache.cassandra.service.StorageLoadBalancer;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.service.StreamManager;
import org.apache.cassandra.service.TokenUpdateVerbHandler;
import org.apache.cassandra.service.UnavailableException;
import org.apache.cassandra.tools.MembershipCleanerVerbHandler;
import org.apache.cassandra.utils.FileUtils;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public final class StorageService
implements IEndPointStateChangeSubscriber,
StorageServiceMBean {
    private static Logger logger_ = Logger.getLogger(StorageService.class);
    private static final String nodeId_ = "NODE-IDENTIFIER";
    private static final String BOOTSTRAP_MODE = "BOOTSTRAP-MODE";
    private static final long threshold_ = 300000L;
    public static final String mutationStage_ = "ROW-MUTATION-STAGE";
    public static final String readStage_ = "ROW-READ-STAGE";
    public static final String mutationVerbHandler_ = "ROW-MUTATION-VERB-HANDLER";
    public static final String tokenVerbHandler_ = "TOKEN-VERB-HANDLER";
    public static final String binaryVerbHandler_ = "BINARY-VERB-HANDLER";
    public static final String readRepairVerbHandler_ = "READ-REPAIR-VERB-HANDLER";
    public static final String readVerbHandler_ = "ROW-READ-VERB-HANDLER";
    public static final String bootStrapInitiateVerbHandler_ = "BOOTSTRAP-INITIATE-VERB-HANDLER";
    public static final String bootStrapInitiateDoneVerbHandler_ = "BOOTSTRAP-INITIATE-DONE-VERB-HANDLER";
    public static final String bootStrapTerminateVerbHandler_ = "BOOTSTRAP-TERMINATE-VERB-HANDLER";
    public static final String dataFileVerbHandler_ = "DATA-FILE-VERB-HANDLER";
    public static final String mbrshipCleanerVerbHandler_ = "MBRSHIP-CLEANER-VERB-HANDLER";
    public static final String bsMetadataVerbHandler_ = "BS-METADATA-VERB-HANDLER";
    public static final String rangeVerbHandler_ = "RANGE-VERB-HANDLER";
    private static StorageService instance_;
    private static Lock createLock_;
    private static EndPoint tcpAddr_;
    private static EndPoint udpAddr_;
    private static IPartitioner partitioner_;
    private IEndPointSnitch endPointSnitch_;
    private TokenMetadata tokenMetadata_ = new TokenMetadata();
    private SystemTable.StorageMetadata storageMetadata_;
    private Timer loadTimer_ = new Timer(false);
    private ExecutorService bootStrapper_ = new DebuggableThreadPoolExecutor("BOOT-STRAPPER");
    private ExecutorService consistencyManager_;
    private StorageLoadBalancer storageLoadBalancer_;
    private AbstractReplicationStrategy nodePicker_;
    private boolean isBootstrapMode;
    private Set<EndPoint> bootstrapSet;

    public static EndPoint getLocalStorageEndPoint() {
        return tcpAddr_;
    }

    public static EndPoint getLocalControlEndPoint() {
        return udpAddr_;
    }

    public static IPartitioner getPartitioner() {
        return partitioner_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StorageService instance() {
        boolean bootstrap;
        String bs = System.getProperty("bootstrap");
        boolean bl = bootstrap = bs != null && bs.contains("true");
        if (instance_ == null) {
            createLock_.lock();
            try {
                if (instance_ == null) {
                    try {
                        instance_ = new StorageService(bootstrap);
                    }
                    catch (Throwable th) {
                        logger_.error((Object)LogUtil.throwableToString(th));
                        System.exit(1);
                    }
                }
            }
            finally {
                createLock_.unlock();
            }
        }
        return instance_;
    }

    public synchronized void addBootstrapSource(EndPoint s) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Added " + s.getHost() + " as a bootstrap source"));
        }
        this.bootstrapSet.add(s);
    }

    public synchronized boolean removeBootstrapSource(EndPoint s) {
        this.bootstrapSet.remove(s);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Removed " + s.getHost() + " as a bootstrap source"));
        }
        if (this.bootstrapSet.isEmpty()) {
            this.isBootstrapMode = false;
            this.tokenMetadata_.update(this.storageMetadata_.getToken(), tcpAddr_, false);
            logger_.info((Object)"Bootstrap completed! Now serving reads.");
            Gossiper.instance().deleteApplicationState(BOOTSTRAP_MODE);
        }
        return this.isBootstrapMode;
    }

    private void init() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this, new ObjectName("org.apache.cassandra.service:type=StorageService"));
        }
        catch (Exception e) {
            logger_.error((Object)LogUtil.throwableToString(e));
        }
    }

    public StorageService(boolean isBootstrapMode) {
        this.isBootstrapMode = isBootstrapMode;
        this.bootstrapSet = new HashSet<EndPoint>();
        this.init();
        this.storageLoadBalancer_ = new StorageLoadBalancer(this);
        this.endPointSnitch_ = DatabaseDescriptor.getEndPointSnitch();
        MessagingService.getMessagingInstance().registerVerbHandlers(tokenVerbHandler_, new TokenUpdateVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(binaryVerbHandler_, new BinaryVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(mutationVerbHandler_, new RowMutationVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(readRepairVerbHandler_, new ReadRepairVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(readVerbHandler_, new ReadVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(bootStrapInitiateVerbHandler_, new Table.BootStrapInitiateVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(bootStrapInitiateDoneVerbHandler_, new BootstrapInitiateDoneVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(bootStrapTerminateVerbHandler_, new StreamManager.BootstrapTerminateVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(dataFileVerbHandler_, new DataFileVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(mbrshipCleanerVerbHandler_, new MembershipCleanerVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(bsMetadataVerbHandler_, new BootstrapMetadataVerbHandler());
        MessagingService.getMessagingInstance().registerVerbHandlers(rangeVerbHandler_, new RangeVerbHandler());
        this.consistencyManager_ = new DebuggableThreadPoolExecutor(DatabaseDescriptor.getConsistencyThreads(), DatabaseDescriptor.getConsistencyThreads(), Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl("CONSISTENCY-MANAGER"));
        StageManager.registerStage(mutationStage_, new MultiThreadedStage(mutationStage_, DatabaseDescriptor.getConcurrentWriters()));
        StageManager.registerStage(readStage_, new MultiThreadedStage(readStage_, DatabaseDescriptor.getConcurrentReaders()));
        Class cls = DatabaseDescriptor.getReplicaPlacementStrategyClass();
        Class[] parameterTypes = new Class[]{TokenMetadata.class, IPartitioner.class, Integer.TYPE, Integer.TYPE};
        try {
            this.nodePicker_ = (AbstractReplicationStrategy)cls.getConstructor(parameterTypes).newInstance(this.tokenMetadata_, partitioner_, DatabaseDescriptor.getReplicationFactor(), DatabaseDescriptor.getStoragePort());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() throws IOException {
        this.storageMetadata_ = SystemTable.initMetadata();
        tcpAddr_ = new EndPoint(DatabaseDescriptor.getStoragePort());
        udpAddr_ = new EndPoint(DatabaseDescriptor.getControlPort());
        MessagingService.getMessagingInstance().listen(tcpAddr_);
        MessagingService.getMessagingInstance().listenUDP(udpAddr_);
        SelectorManager.getSelectorManager().start();
        SelectorManager.getUdpSelectorManager().start();
        this.loadTimer_.schedule((TimerTask)new LoadDisseminator(), 300000L, 300000L);
        this.storageLoadBalancer_.start();
        Gossiper.instance().register(this);
        Gossiper.instance().start(udpAddr_, this.storageMetadata_.getGeneration());
        this.tokenMetadata_.update(this.storageMetadata_.getToken(), tcpAddr_, this.isBootstrapMode);
        ApplicationState state = new ApplicationState(StorageService.getPartitioner().getTokenFactory().toString(this.storageMetadata_.getToken()));
        Gossiper.instance().addApplicationState(nodeId_, state);
        if (this.isBootstrapMode) {
            logger_.info((Object)"Starting in bootstrap mode");
            this.doBootstrap(StorageService.getLocalStorageEndPoint());
            Gossiper.instance().addApplicationState(BOOTSTRAP_MODE, new ApplicationState(""));
        }
    }

    public boolean isBootstrapMode() {
        return this.isBootstrapMode;
    }

    public TokenMetadata getTokenMetadata() {
        return this.tokenMetadata_.cloneMe();
    }

    public void updateTokenMetadata(Token token, EndPoint endpoint) {
        this.tokenMetadata_.update(token, endpoint);
    }

    public IEndPointSnitch getEndPointSnitch() {
        return this.endPointSnitch_;
    }

    public boolean isInSameDataCenter(EndPoint endpoint) throws IOException {
        return this.endPointSnitch_.isInSameDataCenter(tcpAddr_, endpoint);
    }

    public void doConsistencyCheck(Row row, List<EndPoint> endpoints, ReadCommand command) {
        ConsistencyManager consistencySentinel = new ConsistencyManager(row.cloneMe(), endpoints, command);
        this.consistencyManager_.submit(consistencySentinel);
    }

    @Override
    public Map<Range, List<EndPoint>> getRangeToEndPointMap() {
        Map<Token, EndPoint> tokenToEndPointMap = this.tokenMetadata_.cloneTokenEndPointMap();
        Range[] ranges = this.getAllRanges(tokenToEndPointMap.keySet());
        return this.constructRangeToEndPointMap(ranges);
    }

    public Map<Range, List<EndPoint>> constructRangeToEndPointMap(Range[] ranges) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)"Constructing range to endpoint map ...");
        }
        HashMap<Range, List<EndPoint>> rangeToEndPointMap = new HashMap<Range, List<EndPoint>>();
        for (Range range : ranges) {
            EndPoint[] endpoints = this.nodePicker_.getReadStorageEndPoints(range.right());
            rangeToEndPointMap.put(range, new ArrayList<EndPoint>(Arrays.asList(endpoints)));
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)"Done constructing range to endpoint map ...");
        }
        return rangeToEndPointMap;
    }

    public Map<Range, List<EndPoint>> constructRangeToEndPointMap(Range[] ranges, Map<Token, EndPoint> tokenToEndPointMap) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)"Constructing range to endpoint map ...");
        }
        HashMap<Range, List<EndPoint>> rangeToEndPointMap = new HashMap<Range, List<EndPoint>>();
        for (Range range : ranges) {
            EndPoint[] endpoints = this.nodePicker_.getReadStorageEndPoints(range.right(), tokenToEndPointMap);
            rangeToEndPointMap.put(range, new ArrayList<EndPoint>(Arrays.asList(endpoints)));
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)"Done constructing range to endpoint map ...");
        }
        return rangeToEndPointMap;
    }

    public Map<EndPoint, List<Range>> constructEndPointToRangesMap() {
        HashMap<EndPoint, List<Range>> endPointToRangesMap = new HashMap<EndPoint, List<Range>>();
        Map<Token, EndPoint> tokenToEndPointMap = this.tokenMetadata_.cloneTokenEndPointMap();
        for (EndPoint mbr : tokenToEndPointMap.values()) {
            endPointToRangesMap.put(mbr, this.getRangesForEndPoint(mbr));
        }
        return endPointToRangesMap;
    }

    @Override
    public void onChange(EndPoint endpoint, EndPointState epState) {
        boolean bootstrapState;
        EndPoint ep = new EndPoint(endpoint.getHost(), DatabaseDescriptor.getStoragePort());
        ApplicationState nodeIdState = epState.getApplicationState(nodeId_);
        boolean bl = bootstrapState = epState.getApplicationState(BOOTSTRAP_MODE) != null;
        if (bootstrapState && logger_.isDebugEnabled()) {
            logger_.debug((Object)(ep.getHost() + " is in bootstrap state."));
        }
        if (nodeIdState != null) {
            Token oldToken;
            Token newToken = StorageService.getPartitioner().getTokenFactory().fromString(nodeIdState.getState());
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("CHANGE IN STATE FOR " + endpoint + " - has token " + nodeIdState.getState()));
            }
            if ((oldToken = this.tokenMetadata_.getToken(ep)) != null) {
                if (!oldToken.equals(newToken)) {
                    if (logger_.isDebugEnabled()) {
                        logger_.debug((Object)("Relocation for endpoint " + ep));
                    }
                    this.tokenMetadata_.update(newToken, ep, bootstrapState);
                } else {
                    if (logger_.isDebugEnabled()) {
                        logger_.debug((Object)("Sending hinted data to " + ep));
                    }
                    this.deliverHints(endpoint);
                }
            } else {
                this.tokenMetadata_.update(newToken, ep, bootstrapState);
            }
        } else if (epState.isAlive() && this.tokenMetadata_.isKnownEndPoint(endpoint)) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("EndPoint " + ep + " just recovered from a partition. Sending hinted data."));
            }
            this.deliverHints(ep);
        }
    }

    @Override
    public String getLoadInfo() {
        long diskSpace = FileUtils.getUsedDiskSpace();
        return FileUtils.stringifyFileSize(diskSpace);
    }

    public String getLoadInfo(EndPoint ep) {
        LoadInfo li = this.storageLoadBalancer_.getLoad(ep);
        return li == null ? "N/A" : li.toString();
    }

    public void updateToken(Token token) throws IOException {
        SystemTable.updateToken(token);
        this.tokenMetadata_.update(token, tcpAddr_);
        ApplicationState state = new ApplicationState(StorageService.getPartitioner().getTokenFactory().toString(token));
        Gossiper.instance().addApplicationState(nodeId_, state);
    }

    public void removeTokenState(EndPoint endpoint) {
        this.tokenMetadata_.remove(endpoint);
        Gossiper.instance().removeFromMembership(endpoint);
    }

    public void relocate(String[] keys) throws IOException {
        if (keys.length > 0) {
            Token token = this.tokenMetadata_.getToken(tcpAddr_);
            Map<Token, EndPoint> tokenToEndPointMap = this.tokenMetadata_.cloneTokenEndPointMap();
            Object[] tokens = tokenToEndPointMap.keySet().toArray(new Token[tokenToEndPointMap.keySet().size()]);
            Arrays.sort(tokens);
            int index = Arrays.binarySearch(tokens, token) * (keys.length / tokens.length);
            Object newToken = partitioner_.getToken(keys[index]);
            this.updateToken((Token)newToken);
        }
    }

    private void doBootstrap(String nodes) throws UnknownHostException {
        String[] allNodes = nodes.split(":");
        EndPoint[] endpoints = new EndPoint[allNodes.length];
        Token[] tokens = new Token[allNodes.length];
        for (int i = 0; i < allNodes.length; ++i) {
            String host = allNodes[i].trim();
            InetAddress ip = InetAddress.getByName(host);
            host = ip.getHostAddress();
            endpoints[i] = new EndPoint(host, DatabaseDescriptor.getStoragePort());
            tokens[i] = this.tokenMetadata_.getToken(endpoints[i]);
        }
        this.bootStrapper_.submit(new BootStrapper(endpoints, tokens));
    }

    public final void doBootstrap(EndPoint endpoint) {
        Token token = this.tokenMetadata_.getToken(endpoint);
        this.bootStrapper_.submit(new BootStrapper(new EndPoint[]{endpoint}, token));
    }

    public final void deliverHints(EndPoint endpoint) {
        HintedHandOffManager.instance().deliverHints(endpoint);
    }

    public String getToken(EndPoint ep) {
        EndPoint ep2 = new EndPoint(ep.getHost(), DatabaseDescriptor.getStoragePort());
        Token token = this.tokenMetadata_.getToken(ep2);
        return token == null ? "" : token.toString();
    }

    @Override
    public String getToken() {
        return this.tokenMetadata_.getToken(tcpAddr_).toString();
    }

    @Override
    public String getLiveNodes() {
        return this.stringify(Gossiper.instance().getLiveMembers());
    }

    @Override
    public String getUnreachableNodes() {
        return this.stringify(Gossiper.instance().getUnreachableMembers());
    }

    @Override
    public int getCurrentGenerationNumber() {
        return Gossiper.instance().getCurrentGenerationNumber(udpAddr_);
    }

    private String stringify(Set<EndPoint> eps) {
        StringBuilder sb = new StringBuilder("");
        for (EndPoint ep : eps) {
            sb.append(ep);
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    public void loadAll(String nodes) throws UnknownHostException {
        this.doBootstrap(nodes);
    }

    @Override
    public void forceTableCleanup() throws IOException {
        List<String> tables = DatabaseDescriptor.getTables();
        for (String tName : tables) {
            Table table = Table.open(tName);
            table.forceCleanup();
        }
    }

    @Override
    public void forceTableCompaction() throws IOException {
        List<String> tables = DatabaseDescriptor.getTables();
        for (String tName : tables) {
            Table table = Table.open(tName);
            table.forceCompaction();
        }
    }

    @Override
    public void forceHandoff(List<String> dataDirectories, String host) throws IOException {
        ArrayList filesList = new ArrayList();
        ArrayList<StreamContextManager.StreamContext> streamContexts = new ArrayList<StreamContextManager.StreamContext>();
        for (String dataDir : dataDirectories) {
            File directory = new File(dataDir);
            Collections.addAll(filesList, directory.listFiles());
            for (File tableDir : directory.listFiles()) {
                String tableName = tableDir.getName();
                for (File file : tableDir.listFiles()) {
                    streamContexts.add(new StreamContextManager.StreamContext(file.getAbsolutePath(), file.length(), tableName));
                    if (!logger_.isDebugEnabled()) continue;
                    logger_.debug((Object)("Stream context metadata " + streamContexts));
                }
            }
        }
        if (streamContexts.size() > 0) {
            EndPoint target = new EndPoint(host, DatabaseDescriptor.getStoragePort());
            StreamContextManager.StreamContext[] contexts = streamContexts.toArray(new StreamContextManager.StreamContext[streamContexts.size()]);
            StreamManager.instance(target).addFilesToStream(contexts);
            StreamContextManager.StreamContext[] bootContexts = streamContexts.toArray(new StreamContextManager.StreamContext[streamContexts.size()]);
            BootstrapInitiateMessage biMessage = new BootstrapInitiateMessage(bootContexts);
            Message message = BootstrapInitiateMessage.makeBootstrapInitiateMessage(biMessage);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Sending a bootstrap initiate message to " + target + " ..."));
            }
            MessagingService.getMessagingInstance().sendOneWay(message, target);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Waiting for transfer to " + target + " to complete"));
            }
            StreamManager.instance(target).waitForStreamCompletion();
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Done with transfer to " + target));
            }
        }
    }

    @Override
    public void takeSnapshot(String tableName, String tag) throws IOException {
        if (DatabaseDescriptor.getTable(tableName) == null) {
            throw new IOException("Table " + tableName + "does not exist");
        }
        Table tableInstance = Table.open(tableName);
        tableInstance.snapshot(tag);
    }

    @Override
    public void takeAllSnapshot(String tag) throws IOException {
        for (String tableName : DatabaseDescriptor.getTables()) {
            Table tableInstance = Table.open(tableName);
            tableInstance.snapshot(tag);
        }
    }

    @Override
    public void clearSnapshot() throws IOException {
        for (String tableName : DatabaseDescriptor.getTables()) {
            Table tableInstance = Table.open(tableName);
            tableInstance.clearSnapshot();
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)"Cleared out all snapshot directories");
        }
    }

    @Override
    public void forceTableFlushBinary(String tableName) throws IOException {
        if (DatabaseDescriptor.getTable(tableName) == null) {
            throw new IOException("Table " + tableName + "does not exist");
        }
        Table table = Table.open(tableName);
        Set<String> columnFamilies = table.getColumnFamilies();
        for (String columnFamily : columnFamilies) {
            ColumnFamilyStore cfStore = table.getColumnFamilyStore(columnFamily);
            logger_.debug((Object)("Forcing flush on keyspace " + tableName + " on CF " + columnFamily));
            cfStore.forceFlushBinary();
        }
    }

    EndPoint getPredecessor(EndPoint ep) {
        Token token = this.tokenMetadata_.getToken(ep);
        Map<Token, EndPoint> tokenToEndPointMap = this.tokenMetadata_.cloneTokenEndPointMap();
        ArrayList<Token> tokens = new ArrayList<Token>(tokenToEndPointMap.keySet());
        Collections.sort(tokens);
        int index = Collections.binarySearch(tokens, token);
        return index == 0 ? tokenToEndPointMap.get(tokens.get(tokens.size() - 1)) : tokenToEndPointMap.get(tokens.get(--index));
    }

    public EndPoint getSuccessor(EndPoint ep) {
        Token token = this.tokenMetadata_.getToken(ep);
        Map<Token, EndPoint> tokenToEndPointMap = this.tokenMetadata_.cloneTokenEndPointMap();
        ArrayList<Token> tokens = new ArrayList<Token>(tokenToEndPointMap.keySet());
        Collections.sort(tokens);
        int index = Collections.binarySearch(tokens, token);
        return index == tokens.size() - 1 ? tokenToEndPointMap.get(tokens.get(0)) : tokenToEndPointMap.get(tokens.get(++index));
    }

    public Range getPrimaryRangeForEndPoint(EndPoint ep) {
        Token right = this.tokenMetadata_.getToken(ep);
        EndPoint predecessor = this.getPredecessor(ep);
        Token left = this.tokenMetadata_.getToken(predecessor);
        return new Range(left, right);
    }

    List<Range> getRangesForEndPoint(EndPoint ep) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(this.getPrimaryRangeForEndPoint(ep));
        EndPoint predecessor = ep;
        int count = DatabaseDescriptor.getReplicationFactor() - 1;
        for (int i = 0; i < count; ++i) {
            predecessor = this.getPredecessor(predecessor);
            ranges.add(this.getPrimaryRangeForEndPoint(predecessor));
        }
        return ranges;
    }

    public Range[] getAllRanges() {
        return this.getAllRanges(this.tokenMetadata_.cloneTokenEndPointMap().keySet());
    }

    public Range[] getAllRanges(Set<Token> tokens) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        ArrayList<Token> allTokens = new ArrayList<Token>(tokens);
        Collections.sort(allTokens);
        int size = allTokens.size();
        for (int i = 1; i < size; ++i) {
            Range range = new Range((Token)allTokens.get(i - 1), (Token)allTokens.get(i));
            ranges.add(range);
        }
        Range range = new Range((Token)allTokens.get(size - 1), (Token)allTokens.get(0));
        ranges.add(range);
        return ranges.toArray(new Range[0]);
    }

    public EndPoint getPrimary(String key) {
        EndPoint endpoint = tcpAddr_;
        Object token = partitioner_.getToken(key);
        Map<Token, EndPoint> tokenToEndPointMap = this.tokenMetadata_.cloneTokenEndPointMap();
        ArrayList<Token> tokens = new ArrayList<Token>(tokenToEndPointMap.keySet());
        if (tokens.size() > 0) {
            Collections.sort(tokens);
            int index = Collections.binarySearch(tokens, token);
            endpoint = index >= 0 ? tokenToEndPointMap.get(tokens.get(index)) : ((index = (index + 1) * -1) < tokens.size() ? tokenToEndPointMap.get(tokens.get(index)) : tokenToEndPointMap.get(tokens.get(0)));
        }
        return endpoint;
    }

    public boolean isPrimary(String key) {
        EndPoint endpoint = this.getPrimary(key);
        return tcpAddr_.equals(endpoint);
    }

    public EndPoint[] getReadStorageEndPoints(String key) {
        return this.nodePicker_.getReadStorageEndPoints((Token)partitioner_.getToken(key));
    }

    public List<EndPoint> getLiveReadStorageEndPoints(String key) {
        EndPoint[] endpoints;
        ArrayList<EndPoint> liveEps = new ArrayList<EndPoint>();
        for (EndPoint endpoint : endpoints = this.getReadStorageEndPoints(key)) {
            if (!FailureDetector.instance().isAlive(endpoint)) continue;
            liveEps.add(endpoint);
        }
        return liveEps;
    }

    public Map<EndPoint, EndPoint> getHintedStorageEndpointMap(String key) {
        return this.nodePicker_.getHintedStorageEndPoints((Token)partitioner_.getToken(key));
    }

    public EndPoint findSuitableEndPoint(String key) throws IOException, UnavailableException {
        int j;
        EndPoint[] endpoints;
        for (EndPoint endPoint : endpoints = this.getReadStorageEndPoints(key)) {
            if (!endPoint.equals(StorageService.getLocalStorageEndPoint())) continue;
            return endPoint;
        }
        for (j = 0; j < endpoints.length; ++j) {
            if (!StorageService.instance().isInSameDataCenter(endpoints[j]) || !FailureDetector.instance().isAlive(endpoints[j])) continue;
            return endpoints[j];
        }
        for (j = 0; j < endpoints.length; ++j) {
            if (!FailureDetector.instance().isAlive(endpoints[j])) continue;
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("EndPoint " + endpoints[j] + " is alive so get data from it."));
            }
            return endpoints[j];
        }
        throw new UnavailableException();
    }

    Map<Token, EndPoint> getLiveEndPointMap() {
        return this.tokenMetadata_.cloneTokenEndPointMap();
    }

    @Override
    public void setLog4jLevel(String classQualifier, String rawLevel) {
        Level level = Level.toLevel((String)rawLevel);
        Logger.getLogger((String)classQualifier).setLevel(level);
        logger_.info((Object)("set log level to " + level + " for classes under '" + classQualifier + "' (if the level doesn't look like '" + rawLevel + "' then log4j couldn't parse '" + rawLevel + "')"));
    }

    static {
        createLock_ = new ReentrantLock();
        partitioner_ = DatabaseDescriptor.getPartitioner();
    }

    public static class BootstrapInitiateDoneVerbHandler
    implements IVerbHandler {
        private static Logger logger_ = Logger.getLogger(BootstrapInitiateDoneVerbHandler.class);

        @Override
        public void doVerb(Message message) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Received a bootstrap initiate done message ...");
            }
            StreamManager.instance(message.getFrom()).start();
        }
    }
}

