/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.SingleThreadedStage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.concurrent.ThreadFactoryImpl;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndPointStateChangeSubscriber;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.LoadInfo;
import org.apache.cassandra.service.StorageService;
import org.apache.log4j.Logger;

final class StorageLoadBalancer
implements IEndPointStateChangeSubscriber {
    private static final Logger logger_ = Logger.getLogger(StorageLoadBalancer.class);
    private static final String lbStage_ = "LOAD-BALANCER-STAGE";
    private static final String moveMessageVerbHandler_ = "MOVE-MESSAGE-VERB-HANDLER";
    private static final int delay_ = 5;
    private static final double ratio_ = 1.5;
    private StorageService storageService_;
    private AtomicBoolean isMoveable_ = new AtomicBoolean(false);
    private Map<EndPoint, LoadInfo> loadInfo_ = new HashMap<EndPoint, LoadInfo>();
    private Map<EndPoint, LoadInfo> loadInfo2_ = new HashMap<EndPoint, LoadInfo>();
    private ScheduledThreadPoolExecutor lb_ = new DebuggableScheduledThreadPoolExecutor(1, new ThreadFactoryImpl("LB-OPERATIONS"));
    private ExecutorService lbOperations_ = new DebuggableThreadPoolExecutor("LB-TARGET");

    StorageLoadBalancer(StorageService storageService) {
        this.storageService_ = storageService;
        StageManager.registerStage(lbStage_, new SingleThreadedStage(lbStage_));
        MessagingService.getMessagingInstance().registerVerbHandlers(moveMessageVerbHandler_, new MoveMessageVerbHandler());
    }

    public void start() {
        Gossiper.instance().register(this);
    }

    @Override
    public void onChange(EndPoint endpoint, EndPointState epState) {
        ApplicationState loadInfoState = epState.getApplicationState("LOAD-INFORMATION");
        if (loadInfoState != null) {
            String lInfoState = loadInfoState.getState();
            LoadInfo lInfo = new LoadInfo(lInfoState);
            this.loadInfo_.put(endpoint, lInfo);
        }
    }

    LoadInfo getLoad(EndPoint ep) {
        LoadInfo li = this.loadInfo_.get(ep);
        return li;
    }

    private boolean isANeighbour(EndPoint neighbour) {
        EndPoint predecessor = this.storageService_.getPredecessor(StorageService.getLocalStorageEndPoint());
        if (predecessor.equals(neighbour)) {
            return true;
        }
        EndPoint successor = this.storageService_.getSuccessor(StorageService.getLocalStorageEndPoint());
        return successor.equals(neighbour);
    }

    class MoveMessageVerbHandler
    implements IVerbHandler {
        MoveMessageVerbHandler() {
        }

        @Override
        public void doVerb(Message message) {
            Message reply = message.getReply(StorageService.getLocalStorageEndPoint(), new byte[]{(byte)(StorageLoadBalancer.this.isMoveable_.get() ? 1 : 0)});
            MessagingService.getMessagingInstance().sendOneWay(reply, message.getFrom());
            if (StorageLoadBalancer.this.isMoveable_.get()) {
                StorageLoadBalancer.this.isMoveable_.set(false);
            }
        }
    }

    class LoadBalancer
    implements Runnable {
        LoadBalancer() {
            StorageLoadBalancer.this.loadInfo2_.putAll(StorageLoadBalancer.this.loadInfo_);
        }

        @Override
        public void run() {
        }
    }
}

