/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.SelectionKeyHandler;
import org.apache.cassandra.net.SelectorManager;
import org.apache.cassandra.utils.BasicUtilities;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class UdpConnection
extends SelectionKeyHandler {
    private static Logger logger_ = Logger.getLogger(UdpConnection.class);
    private static final int BUFFER_SIZE = 4096;
    private static final int protocol_ = 195935983;
    private DatagramChannel socketChannel_;
    private SelectionKey key_;
    private EndPoint localEndPoint_;

    public void init() throws IOException {
        this.socketChannel_ = DatagramChannel.open();
        this.socketChannel_.socket().setReuseAddress(true);
        this.socketChannel_.configureBlocking(false);
    }

    public void init(int port) throws IOException {
        this.localEndPoint_ = new EndPoint(port);
        this.socketChannel_ = DatagramChannel.open();
        this.socketChannel_.socket().bind(this.localEndPoint_.getInetAddress());
        this.socketChannel_.socket().setReuseAddress(true);
        this.socketChannel_.configureBlocking(false);
        this.key_ = SelectorManager.getUdpSelectorManager().register(this.socketChannel_, this, 1);
    }

    public boolean write(Message message, EndPoint to) throws IOException {
        boolean bVal = true;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        Message.serializer().serialize(message, dos);
        byte[] data = bos.toByteArray();
        if (data.length > 0) {
            if (logger_.isTraceEnabled()) {
                logger_.trace((Object)("Size of Gossip packet " + data.length));
            }
            byte[] protocol = BasicUtilities.intToByteArray(195935983);
            ByteBuffer buffer = ByteBuffer.allocate(data.length + protocol.length);
            buffer.put(protocol);
            buffer.put(data);
            buffer.flip();
            int n = this.socketChannel_.send(buffer, to.getInetAddress());
            if (n == 0) {
                bVal = false;
            }
        }
        return bVal;
    }

    void close() {
        try {
            if (this.socketChannel_ != null) {
                this.socketChannel_.close();
            }
        }
        catch (IOException ex) {
            logger_.error((Object)LogUtil.throwableToString(ex));
        }
    }

    public DatagramChannel getDatagramChannel() {
        return this.socketChannel_;
    }

    private byte[] gobbleHeaderAndExtractBody(ByteBuffer buffer) {
        byte[] body = new byte[]{};
        byte[] protocol = new byte[4];
        buffer = buffer.get(protocol, 0, protocol.length);
        int value = BasicUtilities.byteArrayToInt(protocol);
        if (195935983 != value) {
            logger_.info((Object)("Invalid protocol header in the incoming message " + value));
            return body;
        }
        body = new byte[buffer.remaining()];
        buffer.get(body, 0, body.length);
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(SelectionKey key) {
        UdpConnection.turnOffInterestOps(key, 1);
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        try {
            SocketAddress sa = this.socketChannel_.receive(buffer);
            if (sa == null) {
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)"*** No datagram packet was available to be read ***");
                }
                return;
            }
            buffer.flip();
            byte[] bytes = this.gobbleHeaderAndExtractBody(buffer);
            if (bytes.length > 0) {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
                Message message = Message.serializer().deserialize(dis);
                if (message != null) {
                    MessagingService.receive(message);
                }
            }
        }
        catch (IOException ioe) {
            logger_.warn((Object)LogUtil.throwableToString(ioe));
        }
        finally {
            UdpConnection.turnOnInterestOps(this.key_, 1);
        }
    }
}

