/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.TcpConnection;

class TcpConnectionManager {
    private Lock lock_ = new ReentrantLock();
    private List<TcpConnection> allConnections_;
    private EndPoint localEp_;
    private EndPoint remoteEp_;
    private int initialSize_;
    private int growthFactor_;
    private int maxSize_;
    private long lastTimeUsed_;
    private boolean isShut_;
    private int inUse_;

    TcpConnectionManager(int initialSize, int growthFactor, int maxSize, EndPoint localEp, EndPoint remoteEp) {
        this.initialSize_ = initialSize;
        this.growthFactor_ = growthFactor;
        this.maxSize_ = maxSize;
        this.localEp_ = localEp;
        this.remoteEp_ = remoteEp;
        this.isShut_ = false;
        this.lastTimeUsed_ = System.currentTimeMillis();
        this.allConnections_ = new Vector<TcpConnection>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TcpConnection getConnection() throws IOException {
        this.lock_.lock();
        try {
            if (this.allConnections_.isEmpty()) {
                TcpConnection conn = new TcpConnection(this, this.localEp_, this.remoteEp_);
                this.addToPool(conn);
                conn.inUse_ = true;
                this.incUsed();
                TcpConnection tcpConnection = conn;
                return tcpConnection;
            }
            TcpConnection least = this.getLeastLoaded();
            if (least != null && least.pending() == 0 || this.allConnections_.size() == this.maxSize_) {
                least.inUse_ = true;
                this.incUsed();
                TcpConnection tcpConnection = least;
                return tcpConnection;
            }
            TcpConnection connection = new TcpConnection(this, this.localEp_, this.remoteEp_);
            if (connection != null && !this.contains(connection)) {
                this.addToPool(connection);
                connection.inUse_ = true;
                this.incUsed();
                TcpConnection tcpConnection = connection;
                return tcpConnection;
            }
            if (connection != null) {
                connection.closeSocket();
            }
            TcpConnection tcpConnection = this.getLeastLoaded();
            return tcpConnection;
        }
        finally {
            this.lock_.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TcpConnection getLeastLoaded() {
        TcpConnection connection = null;
        this.lock_.lock();
        try {
            Collections.sort(this.allConnections_);
            connection = this.allConnections_.size() > 0 ? this.allConnections_.get(0) : null;
        }
        finally {
            this.lock_.unlock();
        }
        return connection;
    }

    void removeConnection(TcpConnection connection) {
        this.allConnections_.remove(connection);
    }

    void incUsed() {
        ++this.inUse_;
    }

    void decUsed() {
        --this.inUse_;
    }

    int getConnectionsInUse() {
        return this.inUse_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToPool(TcpConnection connection) {
        if (this.contains(connection)) {
            return;
        }
        this.lock_.lock();
        try {
            if (this.allConnections_.size() < this.maxSize_) {
                this.allConnections_.add(connection);
            } else {
                connection.closeSocket();
            }
        }
        finally {
            this.lock_.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.lock_.lock();
        try {
            while (this.allConnections_.size() > 0) {
                TcpConnection connection = this.allConnections_.remove(0);
                connection.closeSocket();
            }
        }
        finally {
            this.lock_.unlock();
        }
        this.isShut_ = true;
    }

    int getPoolSize() {
        return this.allConnections_.size();
    }

    EndPoint getLocalEndPoint() {
        return this.localEp_;
    }

    EndPoint getRemoteEndPoint() {
        return this.remoteEp_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPendingWrites() {
        int total = 0;
        this.lock_.lock();
        try {
            for (TcpConnection connection : this.allConnections_) {
                total += connection.pending();
            }
        }
        finally {
            this.lock_.unlock();
        }
        return total;
    }

    boolean contains(TcpConnection connection) {
        return this.allConnections_.contains(connection);
    }

    List<TcpConnection> getConnections() {
        return this.allConnections_;
    }
}

